/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.dialog.attributes;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.ui.dialog.ListDialog;
import org.gitools.ui.dialog.attributes.AttributesSelectionModel;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.FileChooserUtils;

public class AttributesSelectionDialog<T>
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private AttributesSelectionModel listModel;
    private JButton addBtn;
    private JButton cancelButton;
    private JButton downBtn;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JList list;
    private JButton loadBtn;
    private JButton okButton;
    private JButton removeBtn;
    private JButton saveBtn;
    private JButton upBtn;
    private int returnStatus = 0;

    public AttributesSelectionDialog(Frame parent, T[] attributes) {
        super(parent, true);
        this.initComponents();
        this.listModel = new AttributesSelectionModel<T>(attributes);
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                AttributesSelectionDialog.this.updateButtons();
            }
        });
        this.list.setModel(this.listModel);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AttributesSelectionDialog.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        boolean thereIsElements = this.listModel.getSize() > 0;
        boolean thereIsSelection = !this.list.getSelectionModel().isSelectionEmpty();
        int totalSize = this.listModel.getAttributes().length;
        List<Integer> selIndices = this.listModel.getSelectedIndices();
        int lastSelectionIndex = selIndices.size() - 1;
        boolean firstSelected = false;
        boolean lastSelected = false;
        for (int i : this.list.getSelectedIndices()) {
            firstSelected |= i == 0;
            lastSelected |= i == lastSelectionIndex;
        }
        this.addBtn.setEnabled(this.listModel.getSize() < totalSize);
        this.removeBtn.setEnabled(thereIsElements && thereIsSelection);
        this.upBtn.setEnabled(thereIsElements && thereIsSelection && !firstSelected);
        this.downBtn.setEnabled(thereIsElements && thereIsSelection && !lastSelected);
        this.saveBtn.setEnabled(thereIsElements);
        this.okButton.setEnabled(thereIsElements);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.loadBtn = new JButton();
        this.saveBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Select attributes to export...");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AttributesSelectionDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.addBtn.setText("Add...");
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.addBtnActionPerformed(evt);
            }
        });
        this.removeBtn.setText("Remove");
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.removeBtnActionPerformed(evt);
            }
        });
        this.upBtn.setText("Move up");
        this.upBtn.setEnabled(false);
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.upBtnActionPerformed(evt);
            }
        });
        this.downBtn.setText("Move down");
        this.downBtn.setEnabled(false);
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.downBtnActionPerformed(evt);
            }
        });
        this.loadBtn.setText("Load...");
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.loadBtnActionPerformed(evt);
            }
        });
        this.saveBtn.setText("Save...");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesSelectionDialog.this.saveBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -1, 424, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.downBtn, -1, -1, Short.MAX_VALUE).addComponent(this.upBtn, -1, -1, Short.MAX_VALUE).addComponent(this.removeBtn, -1, -1, Short.MAX_VALUE).addComponent(this.addBtn, -1, -1, Short.MAX_VALUE).addComponent(this.loadBtn, -1, -1, Short.MAX_VALUE).addComponent(this.saveBtn, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn)).addComponent(this.jScrollPane1, -1, 204, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        ListDialog<Object> dlg = new ListDialog<Object>(this.getOwner(), true, this.listModel.getUnselectedAttributes().toArray());
        dlg.setTitle("Attributes to add");
        dlg.setVisible(true);
        List<Integer> unselIndices = this.listModel.getUnselectedIndices();
        ArrayList<Integer> selIndices = new ArrayList<Integer>();
        if (dlg.getReturnStatus() == 1) {
            for (int i : dlg.getSelectedIndices()) {
                selIndices.add(unselIndices.get(i));
            }
            this.listModel.select(selIndices);
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        int[] listIndices = this.list.getSelectedIndices();
        List<Integer> selIndices = this.listModel.getSelectedIndices();
        ArrayList<Integer> removedIndices = new ArrayList<Integer>(listIndices.length);
        for (int i : listIndices) {
            removedIndices.add(selIndices.get(i));
        }
        this.listModel.unselect(removedIndices);
        this.list.getSelectionModel().clearSelection();
    }

    private void loadBtnActionPerformed(ActionEvent evt) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        T[] attributes = this.listModel.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            indexMap.put(attributes[i].toString().trim(), i);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        try {
            String line;
            File file = FileChooserUtils.selectFile("Select file ...", Settings.getDefault().getLastPath(), 2);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastPath(file.getParent());
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                Integer index;
                if ((line = line.trim()).isEmpty() || (index = (Integer)indexMap.get(line)) == null) continue;
                indices.add(index);
            }
        }
        catch (IOException ex) {
            ExceptionDialog edlg = new ExceptionDialog(this.getOwner(), (Throwable)ex);
            edlg.setVisible(true);
        }
        this.listModel.setSelectedIndices(indices);
        this.list.getSelectionModel().clearSelection();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        T[] attributes = this.listModel.getAttributes();
        try {
            File file = FileChooserUtils.selectFile("Select file name ...", Settings.getDefault().getLastFilterPath(), 1);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastPath(file.getParent());
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            List<Integer> selIndices = this.listModel.getSelectedIndices();
            for (Integer i : selIndices) {
                bw.append(attributes[i].toString()).append('\n');
            }
            bw.close();
        }
        catch (Exception ex) {
            ExceptionDialog edlg = new ExceptionDialog(this.getOwner(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        int[] listIndices = this.list.getSelectedIndices();
        List<Integer> selIndices = this.listModel.getSelectedIndices();
        ArrayList<Integer> moveIndices = new ArrayList<Integer>(listIndices.length);
        for (int i : listIndices) {
            moveIndices.add(selIndices.get(i));
        }
        this.listModel.moveUp(moveIndices);
        int i = 0;
        while (i < listIndices.length) {
            int n = i++;
            listIndices[n] = listIndices[n] - 1;
        }
        this.list.setSelectedIndices(listIndices);
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        int[] listIndices = this.list.getSelectedIndices();
        List<Integer> selIndices = this.listModel.getSelectedIndices();
        ArrayList<Integer> moveIndices = new ArrayList<Integer>(listIndices.length);
        for (int i : listIndices) {
            moveIndices.add(selIndices.get(i));
        }
        this.listModel.moveDown(moveIndices);
        int i = 0;
        while (i < listIndices.length) {
            int n = i++;
            listIndices[n] = listIndices[n] + 1;
        }
        this.list.setSelectedIndices(listIndices);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public List<Integer> getSelectedIndices() {
        return this.listModel.getSelectedIndices();
    }
}

