/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.velocity.VelocityContext;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.panel.TemplatePanel;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = -5869809986725283792L;
    private String appName = AppFrame.getAppName();
    private String appVersion = AppFrame.getAppVersion();
    private TemplatePanel creditsPane;

    public AboutDialog(JFrame owner) {
        super(owner);
        this.setModal(true);
        this.setTitle("About " + this.appName);
        this.createComponents();
        this.pack();
    }

    private void createComponents() {
        JLabel imageLabel = new JLabel(IconUtils.getIconResource((String)"/img/AboutLogo.png"));
        imageLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 0));
        imageLabel.setVerticalAlignment(1);
        this.creditsPane = new TemplatePanel();
        this.creditsPane.setFocusable(false);
        Dimension dim = new Dimension(550, 374);
        this.creditsPane.setPreferredSize(dim);
        this.creditsPane.setMaximumSize(dim);
        try {
            this.creditsPane.setTemplateFromResource("/vm/about.vm");
            VelocityContext context = new VelocityContext();
            context.put("appName", (Object)this.appName);
            context.put("appVersion", (Object)this.appVersion);
            this.creditsPane.setContext(context);
            this.creditsPane.render();
        }
        catch (Exception ex) {
            System.err.println("Unexpected error creating credits pane.");
        }
        JButton acceptBtn = new JButton("Close");
        acceptBtn.setMargin(new Insets(0, 30, 0, 30));
        acceptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.closeDialog();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        btnPanel.setLayout(new BorderLayout());
        btnPanel.add((Component)acceptBtn, "East");
        JPanel contPanel = new JPanel();
        contPanel.setLayout(new BorderLayout());
        contPanel.add((Component)this.creditsPane, "Center");
        contPanel.add((Component)btnPanel, "South");
        contPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this.add((Component)imageLabel, "West");
        this.add((Component)contPanel, "Center");
    }

    protected void closeDialog() {
        this.setVisible(false);
    }
}

