/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.commands;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.commands.AbstractCommand;
import org.gitools.ui.commands.Command;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;

public class CommandLoadFile
extends AbstractCommand {
    private String file;
    private String mime;
    private String rowsAnnotations;
    private String columnsAnnotations;

    public CommandLoadFile(String file) {
        this(file, null);
    }

    public CommandLoadFile(String file, String mime) {
        this(file, mime, null, null);
    }

    public CommandLoadFile(String file, String rowsAnnotations, String columnsAnnotations) {
        this(file, null, rowsAnnotations, columnsAnnotations);
    }

    public CommandLoadFile(String file, String mime, String rowsAnnotations, String columnsAnnotations) {
        this.file = file;
        this.mime = mime;
        this.rowsAnnotations = rowsAnnotations;
        this.columnsAnnotations = columnsAnnotations;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws Command.CommandException {
        IMatrix matrix;
        monitor.begin("Loading ...", 1);
        File file = CommandLoadFile.download(this.file, monitor);
        if (this.mime == null) {
            this.mime = PersistenceManager.getDefault().getMimeFromFile(file.getName());
        }
        try {
            matrix = (IMatrix)PersistenceManager.getDefault().load(file, this.mime, monitor);
        }
        catch (PersistenceException e) {
            throw new Command.CommandException((Exception)((Object)e));
        }
        MatrixView matrixView = new MatrixView(matrix);
        Heatmap figure = HeatmapUtil.createFromMatrixView((IMatrixView)matrixView);
        if (this.rowsAnnotations != null) {
            File rowsFile = CommandLoadFile.download(this.rowsAnnotations, monitor);
            CommandLoadFile.loadAnnotations(rowsFile, figure.getRowDim());
        }
        if (this.columnsAnnotations != null) {
            File colsFile = CommandLoadFile.download(this.columnsAnnotations, monitor);
            CommandLoadFile.loadAnnotations(colsFile, figure.getColumnDim());
        }
        final HeatmapEditor editor = new HeatmapEditor(figure);
        editor.setName(PersistenceUtils.getFileName((String)file.getName()) + "." + "heatmap");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                AppFrame.instance().refresh();
            }
        });
        monitor.end();
    }

    private static File download(String file, IProgressMonitor monitor) throws Command.CommandException {
        File resultFile;
        URL url = null;
        try {
            url = new URL(file);
        }
        catch (Exception e) {
            try {
                url = new File(file).getAbsoluteFile().toURI().toURL();
            }
            catch (MalformedURLException e1) {
                throw new Command.CommandException(e1);
            }
        }
        String fileName = FilenameUtils.getName((String)url.getFile());
        if (url.getProtocol().equals("file")) {
            monitor.info("File: " + fileName);
            try {
                resultFile = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new Command.CommandException(e);
            }
        }
        try {
            resultFile = File.createTempFile("gitools", fileName);
            monitor.info("Downloading " + url.toString());
            FileUtils.copyURLToFile((URL)url, (File)resultFile);
        }
        catch (IOException e) {
            throw new Command.CommandException(e);
        }
        return resultFile;
    }

    private static void loadAnnotations(File file, HeatmapDim hdim) throws Command.CommandException {
        if (file != null) {
            AnnotationMatrix annMatrix = null;
            try {
                annMatrix = (AnnotationMatrix)PersistenceManager.getDefault().load(file, "application/gitools-matrix-annotation", (IProgressMonitor)new NullProgressMonitor());
                annMatrix.setTitle(file.getName());
            }
            catch (PersistenceException e) {
                throw new Command.CommandException((Exception)((Object)e));
            }
            hdim.setAnnotations(annMatrix);
        }
    }
}

