/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.ClusteringMethodFactory;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.WekaKmeansMethod;
import org.gitools.ui.clustering.values.ClusteringValueMethodPage;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import weka.core.EuclideanDistance;
import weka.core.ManhattanDistance;
import weka.core.NormalizableDistance;

public class KmeansParamsPage
extends AbstractWizardPage
implements ClusteringValueMethodPage {
    private JComboBox distAlgCombo;
    private JTextField iterField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JTextField kField;
    private ButtonGroup optGroup;
    private JTextField seedField;

    public KmeansParamsPage() {
        this.initComponents();
        this.setTitle("Clustering method selection");
        this.setComplete(true);
    }

    private boolean validated() {
        return this.isValidInteger(this.iterField.getText()) && this.isValidInteger(this.seedField.getText()) && this.isValidInteger(this.kField.getText());
    }

    public void updateModel() {
        super.updateModel();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.seedField = new JTextField();
        this.jLabel7 = new JLabel();
        this.distAlgCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.iterField = new JTextField();
        this.kField = new JTextField();
        this.jLabel3.setText("Seed: ");
        this.jLabel3.setToolTipText("Set a random value used to start clustering method");
        this.seedField.setText("10");
        this.jLabel7.setText("Distance algorithm: ");
        this.jLabel7.setToolTipText("The distance function to use for instances comparison");
        this.distAlgCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Euclidean", "Manhattan"}));
        this.jLabel1.setText("Num. Clusters: ");
        this.jLabel1.setToolTipText("Set number of clusters");
        this.jLabel2.setText("Max Iterations: ");
        this.jLabel2.setToolTipText("Set maximum number of iterations\nValue must be > 0");
        this.iterField.setText("500");
        this.kField.setText("2");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.distAlgCombo, 0, 290, Short.MAX_VALUE).addComponent(this.seedField, -1, 290, Short.MAX_VALUE).addComponent(this.iterField, -1, 290, Short.MAX_VALUE).addComponent(this.kField, GroupLayout.Alignment.TRAILING, -1, 290, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.distAlgCombo, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.kField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterField, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seedField, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean isValidInteger(String text) {
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @Override
    public AbstractClusteringValueMethod getMethod() {
        WekaKmeansMethod method = null;
        if (this.validated()) {
            method = (WekaKmeansMethod)ClusteringMethodFactory.getDefault().create(this.getMethodDescriptor());
            method.setIterations(Integer.valueOf(this.iterField.getText()).intValue());
            method.setNumClusters(Integer.valueOf(this.kField.getText()).intValue());
            method.setSeed(Integer.valueOf(this.seedField.getText()).intValue());
            if (this.distAlgCombo.getSelectedItem().toString().equalsIgnoreCase("euclidean")) {
                method.setDistanceFunction((NormalizableDistance)new EuclideanDistance());
            } else {
                method.setDistanceFunction((NormalizableDistance)new ManhattanDistance());
            }
        }
        return method;
    }

    @Override
    public ClusteringMethodDescriptor getMethodDescriptor() {
        List descriptors = ClusteringMethodFactory.getDefault().getDescriptors();
        for (ClusteringMethodDescriptor desc : descriptors) {
            if (!desc.getMethodClass().equals(WekaKmeansMethod.class)) continue;
            return desc;
        }
        return null;
    }
}

