/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.ClusteringMethodFactory;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.WekaHCLMethod;
import org.gitools.clustering.method.value.WekaHierarchicalClusterer;
import org.gitools.ui.clustering.values.ClusteringValueMethodPage;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import weka.core.EuclideanDistance;
import weka.core.ManhattanDistance;
import weka.core.NormalizableDistance;
import weka.core.SelectedTag;

public class HCLParamsPage
extends AbstractWizardPage
implements ClusteringValueMethodPage {
    private JComboBox distAlgCombo;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JComboBox linkTypeCombo;
    private ButtonGroup optGroup;

    public HCLParamsPage() {
        this.initComponents();
        this.setTitle("Clustering method selection");
        this.setComplete(true);
    }

    public void updateModel() {
        super.updateModel();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.linkTypeCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.distAlgCombo = new JComboBox();
        this.jLabel7 = new JLabel();
        this.linkTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Complete", "Average", "Mean", "Centroid", "Ward", "Adjcomplete", "Neighbor_joining"}));
        this.jLabel1.setText("Link type: ");
        this.jLabel1.setToolTipText("Sets the method used to measure the distance between two clusters.");
        this.distAlgCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Euclidean", "Manhattan"}));
        this.jLabel7.setText("Distance algorithm: ");
        this.jLabel7.setToolTipText("The distance function to use for instances comparison");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.distAlgCombo, 0, 290, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linkTypeCombo, 0, 290, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.distAlgCombo, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.linkTypeCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public AbstractClusteringValueMethod getMethod() {
        WekaHCLMethod method = null;
        method = (WekaHCLMethod)ClusteringMethodFactory.getDefault().create(this.getMethodDescriptor());
        method.setLinkType(new SelectedTag(this.linkTypeCombo.getSelectedItem().toString(), WekaHierarchicalClusterer.TAGS_LINK_TYPE));
        method.setDistanceIsBranchLength(false);
        method.setNumClusters(1);
        method.setPrintNewick(true);
        if (this.distAlgCombo.getSelectedItem().toString().equalsIgnoreCase("euclidean")) {
            method.setDistanceFunction((NormalizableDistance)new EuclideanDistance());
        } else {
            method.setDistanceFunction((NormalizableDistance)new ManhattanDistance());
        }
        return method;
    }

    @Override
    public ClusteringMethodDescriptor getMethodDescriptor() {
        List descriptors = ClusteringMethodFactory.getDefault().getDescriptors();
        for (ClusteringMethodDescriptor desc : descriptors) {
            if (!desc.getMethodClass().equals(WekaHCLMethod.class)) continue;
            return desc;
        }
        return null;
    }
}

