/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import java.awt.Container;
import java.awt.Font;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.ClusteringMethodFactory;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.WekaCobWebMethod;
import org.gitools.ui.clustering.values.ClusteringValueMethodPage;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class CobwebParamsPage
extends AbstractWizardPage
implements ClusteringValueMethodPage {
    private JTextField acuityField;
    private JTextField cutOffField;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private ButtonGroup optGroup;
    private JTextField seedField;

    public CobwebParamsPage() {
        this.initComponents();
        this.setTitle("Clustering method selection");
        this.setComplete(true);
    }

    private boolean validated() {
        return this.isValidNumber(this.cutOffField.getText()) && this.isValidInteger(this.seedField.getText()) && this.isValidNumber(this.acuityField.getText());
    }

    public void updateModel() {
        super.updateModel();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.acuityField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cutOffField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.seedField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.acuityField.setHorizontalAlignment(2);
        this.acuityField.setText("0.5");
        this.acuityField.setToolTipText("Set the minimum standard deviation of a node of the tree with an only \ninstance.");
        this.jLabel1.setText("Acuity: ");
        this.jLabel1.setToolTipText("Set the minimum standard deviation of a node of the tree with an only \ninstance.\n");
        this.jLabel4.setFont(new Font("DejaVu LGC Sans", 0, 10));
        this.jLabel4.setText("(Hint: decrease this value to obtain more clusters)");
        this.cutOffField.setText("0.0028");
        this.cutOffField.setToolTipText("Set the category utility threshold by which to prune nodes.");
        this.jLabel2.setText("Cutoff: ");
        this.jLabel2.setToolTipText("Set the category utility threshold by which to prune nodes.");
        this.jLabel5.setFont(new Font("DejaVu LGC Sans", 0, 10));
        this.jLabel5.setText("(Hint: decrease this value to obtain more clusters)");
        this.seedField.setText("42");
        this.seedField.setToolTipText("Set a random value used to start clustering method");
        this.jLabel3.setText("Seed: ");
        this.jLabel3.setToolTipText("Set a random value used to start clustering method");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.acuityField, -1, 378, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.cutOffField, -1, 378, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, -2, 0, -2).addComponent(this.seedField, -1, 378, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.acuityField, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutOffField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seedField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 0, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean isValidInteger(String text) {
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @Override
    public AbstractClusteringValueMethod getMethod() {
        WekaCobWebMethod cobweb = null;
        if (this.validated()) {
            cobweb = (WekaCobWebMethod)ClusteringMethodFactory.getDefault().create(this.getMethodDescriptor());
            cobweb.setCutoff(new Float(this.cutOffField.getText()).floatValue());
            cobweb.setSeed(new Integer(this.seedField.getText()).intValue());
            cobweb.setAcuity(new Float(this.acuityField.getText()).floatValue());
        }
        return cobweb;
    }

    @Override
    public ClusteringMethodDescriptor getMethodDescriptor() {
        List descriptors = ClusteringMethodFactory.getDefault().getDescriptors();
        for (ClusteringMethodDescriptor desc : descriptors) {
            if (!desc.getMethodClass().equals(WekaCobWebMethod.class)) continue;
            return desc;
        }
        return null;
    }
}

