/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.MatrixColumnClusteringData;
import org.gitools.clustering.method.value.MatrixRowClusteringData;
import org.gitools.clustering.method.value.WekaCobWebMethod;
import org.gitools.clustering.method.value.WekaHCLMethod;
import org.gitools.clustering.method.value.WekaKmeansMethod;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.clustering.values.ClusteringMethodsPage;
import org.gitools.ui.clustering.values.ClusteringOptionsPage;
import org.gitools.ui.clustering.values.ClusteringValueMethodPage;
import org.gitools.ui.clustering.values.CobwebParamsPage;
import org.gitools.ui.clustering.values.HCLParamsPage;
import org.gitools.ui.clustering.values.KmeansParamsPage;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class ClusteringValueWizard
extends AbstractWizard {
    private Heatmap heatmap;
    private AbstractClusteringValueMethod method;
    private ClusteringMethodsPage methodPage;
    private CobwebParamsPage cobwebPage;
    private HCLParamsPage hclPage;
    private KmeansParamsPage kmeansPage;
    private ClusteringOptionsPage optionsPage;
    private SaveFilePage newickPage;

    public ClusteringValueWizard(Heatmap heatmap) {
        this.heatmap = heatmap;
        this.setTitle("Clustering by value");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Clustering.png", (int)96));
        this.setHelpContext("analysis_overlapping");
    }

    public void addPages() {
        this.methodPage = new ClusteringMethodsPage();
        this.addPage((IWizardPage)this.methodPage);
        IMatrixView mv = this.heatmap.getMatrixView();
        this.optionsPage = new ClusteringOptionsPage(mv.getContents().getCellAttributes(), mv.getSelectedPropertyIndex());
        this.addPage((IWizardPage)this.optionsPage);
        this.newickPage = new SaveFilePage();
        this.newickPage.setTitle("Select Newick's tree destination file");
        this.newickPage.setFolder(Settings.getDefault().getLastExportPath());
        this.newickPage.setFormatsVisible(false);
        this.addPage((IWizardPage)this.newickPage);
        this.hclPage = new HCLParamsPage();
        this.addPage((IWizardPage)this.hclPage);
        this.kmeansPage = new KmeansParamsPage();
        this.addPage((IWizardPage)this.kmeansPage);
        this.cobwebPage = new CobwebParamsPage();
        this.addPage((IWizardPage)this.cobwebPage);
    }

    public void performFinish() {
        Settings.getDefault().setLastExportPath(this.newickPage.getFolder());
        Settings.getDefault().save();
    }

    public boolean canFinish() {
        return this.currentPage == this.cobwebPage || this.currentPage == this.hclPage || this.currentPage == this.kmeansPage;
    }

    public boolean isLastPage(IWizardPage page) {
        return this.currentPage == this.cobwebPage || this.currentPage == this.hclPage || this.currentPage == this.kmeansPage;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        SaveFilePage nextPage = null;
        nextPage = currentPage == this.optionsPage ? (this.optionsPage.isNewickExportSelected() ? this.newickPage : this.getMethodConfigPage()) : (currentPage == this.cobwebPage || currentPage == this.hclPage || currentPage == this.kmeansPage ? null : super.getNextPage(currentPage));
        return nextPage;
    }

    public void pageLeft(IWizardPage currentPage) {
        if (currentPage == this.methodPage) {
            ClusteringMethodDescriptor methodDescriptor = this.methodPage.getMethodDescriptor();
            Class methodClass = methodDescriptor.getMethodClass();
            this.optionsPage.setNewickExportVisible(WekaHCLMethod.class.equals((Object)methodClass));
        } else if (currentPage == this.cobwebPage || currentPage == this.hclPage || currentPage == this.kmeansPage) {
            this.method = ((ClusteringValueMethodPage)currentPage).getMethod();
            this.method.setPreprocess(this.optionsPage.isPreprocessing());
            this.method.setTranspose(this.optionsPage.isApplyToRows());
        }
    }

    private IWizardPage getMethodConfigPage() {
        ClusteringMethodDescriptor methodDescriptor = this.methodPage.getMethodDescriptor();
        Class methodClass = methodDescriptor.getMethodClass();
        if (WekaCobWebMethod.class.equals((Object)methodClass)) {
            return this.cobwebPage;
        }
        if (WekaHCLMethod.class.equals((Object)methodClass)) {
            return this.hclPage;
        }
        if (WekaKmeansMethod.class.equals((Object)methodClass)) {
            return this.kmeansPage;
        }
        return null;
    }

    public ClusteringData getClusterData() {
        int attr = this.optionsPage.getDataAttribute();
        IMatrixView mv = this.heatmap.getMatrixView();
        return this.optionsPage.isApplyToRows() ? new MatrixRowClusteringData((IMatrix)mv, attr) : new MatrixColumnClusteringData((IMatrix)mv, attr);
    }

    public boolean isHeaderSelected() {
        return this.optionsPage.isHeaderSelected();
    }

    public boolean isSortDataSelected() {
        return this.optionsPage.isSort();
    }

    public boolean isNewickExportSelected() {
        return this.optionsPage.isNewickExportSelected();
    }

    public boolean isApplyToRows() {
        return this.optionsPage.isApplyToRows();
    }

    public SaveFilePage getSaveFilePage() {
        return this.newickPage;
    }

    public String getMethodName() {
        return this.methodPage.getMethodDescriptor().getTitle();
    }

    public AbstractClusteringValueMethod getMethod() {
        return this.method;
    }
}

