/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class ClusteringOptionsPage
extends AbstractWizardPage {
    private JComboBox attributeCb;
    private JRadioButton columnsRadio;
    private JCheckBox headerChk;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JCheckBox newickChk;
    private ButtonGroup optGroup;
    private JCheckBox preprocessingChk;
    private JRadioButton rowsRadio;
    private JCheckBox sortChk;

    public ClusteringOptionsPage(List<IElementAttribute> cellAttributes, int index) {
        this.initComponents();
        DefaultComboBoxModel<MatrixAttributeWrapper> model = new DefaultComboBoxModel<MatrixAttributeWrapper>();
        MatrixAttributeWrapper attrWrapper = null;
        for (IElementAttribute attr : cellAttributes) {
            attrWrapper = new MatrixAttributeWrapper(attr);
            model.addElement(attrWrapper);
        }
        this.attributeCb.setModel(model);
        this.attributeCb.setSelectedIndex(index);
        this.newickChk.setVisible(false);
        this.setTitle("Clustering options");
        this.setComplete(true);
    }

    public int getDataAttribute() {
        return this.attributeCb.getSelectedIndex();
    }

    public boolean isApplyToRows() {
        return this.rowsRadio.isSelected();
    }

    public boolean isPreprocessing() {
        return this.preprocessingChk.isSelected();
    }

    public boolean isSort() {
        return this.sortChk.isSelected();
    }

    public boolean isHeaderSelected() {
        return this.headerChk.isSelected();
    }

    public void setHeaderEnabled(boolean res) {
        this.headerChk.setEnabled(res);
    }

    public boolean isNewickExportVisible() {
        return this.newickChk.isVisible();
    }

    public void setNewickExportVisible(boolean enabled) {
        this.newickChk.setVisible(enabled);
    }

    public boolean isNewickExportSelected() {
        return this.newickChk.isVisible() && this.newickChk.isSelected();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.jLabel5 = new JLabel();
        this.columnsRadio = new JRadioButton();
        this.rowsRadio = new JRadioButton();
        this.preprocessingChk = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.attributeCb = new JComboBox();
        this.headerChk = new JCheckBox();
        this.sortChk = new JCheckBox();
        this.newickChk = new JCheckBox();
        this.jLabel5.setText("Apply to:");
        this.optGroup.add(this.columnsRadio);
        this.columnsRadio.setSelected(true);
        this.columnsRadio.setText("columns");
        this.optGroup.add(this.rowsRadio);
        this.rowsRadio.setText("rows");
        this.preprocessingChk.setSelected(true);
        this.preprocessingChk.setText("Apply dimensionality reduction");
        this.jLabel6.setText("Take values from");
        this.headerChk.setText("Add a new header with colors representing clusters");
        this.sortChk.setSelected(true);
        this.sortChk.setText("Sort heatmap by clustering results");
        this.newickChk.setText("Save hierarchical clustering tree in Newick format");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rowsRadio).addGap(307, 307, 307)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributeCb, 0, 418, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preprocessingChk).addComponent(this.sortChk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 288, -2)).addComponent(this.headerChk).addComponent(this.newickChk)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.columnsRadio).addComponent(this.rowsRadio)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.attributeCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.preprocessingChk).addGap(18, 18, 18).addComponent(this.sortChk).addGap(18, 18, 18).addComponent(this.headerChk).addGap(18, 18, 18).addComponent(this.newickChk).addContainerGap(74, Short.MAX_VALUE)));
    }

    private static class MatrixAttributeWrapper {
        private IElementAttribute attribute;

        public MatrixAttributeWrapper(IElementAttribute a) {
            this.attribute = a;
        }

        public IElementAttribute getMatrixAttribute() {
            return this.attribute;
        }

        public void setMatrixAttribute(IElementAttribute a) {
            this.attribute = a;
        }

        public String toString() {
            return this.attribute.getName();
        }
    }
}

