/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.clustering.values;

import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.ClusteringMethodFactory;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class ClusteringMethodsPage
extends AbstractWizardPage {
    private JList annList;
    private JScrollPane jScrollPane1;
    private ButtonGroup optGroup;

    public ClusteringMethodsPage() {
        this.initComponents();
        List descriptors = ClusteringMethodFactory.getDefault().getDescriptors();
        DefaultListModel<ClusteringMethodDescriptor> model = new DefaultListModel<ClusteringMethodDescriptor>();
        for (ClusteringMethodDescriptor desc : descriptors) {
            if (desc.getMethodClass().getSuperclass() == null || !desc.getMethodClass().getSuperclass().equals(AbstractClusteringValueMethod.class)) continue;
            model.addElement(desc);
        }
        this.annList.setModel(model);
        this.annList.setSelectedIndex(0);
        this.annList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClusteringMethodsPage.this.updateCompleted();
            }
        });
        this.setTitle("Clustering method selection");
        this.setComplete(true);
    }

    private void updateCompleted() {
        boolean completed = this.annList.getSelectedIndices().length > 0;
        this.setComplete(completed);
    }

    public void updateModel() {
        super.updateModel();
    }

    public ClusteringMethodDescriptor getMethodDescriptor() {
        int indice = this.annList.getSelectedIndex();
        if (indice >= 0) {
            return (ClusteringMethodDescriptor)this.annList.getModel().getElementAt(indice);
        }
        return null;
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.annList = new JList();
        this.annList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.annList);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 556, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 252, Short.MAX_VALUE).addContainerGap()));
    }
}

