/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.io.File;
import java.util.List;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.Attribute;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.Dataset;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.biomart.restful.model.Query;
import org.gitools.persistence.FileFormat;
import org.gitools.ui.biomart.wizard.BiomartAttributeListPage;
import org.gitools.ui.biomart.wizard.BiomartFilterConfigurationPage;
import org.gitools.ui.biomart.wizard.BiomartSourcePage;
import org.gitools.ui.biomart.wizard.BiomartTableFilteringPage;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class BiomartTableWizard
extends AbstractWizard {
    private SaveFilePage saveFilePage;
    private BiomartService biomartService;
    private DatasetConfig biomartConfig;
    private BiomartAttributeListPage attrListPage;
    private BiomartTableFilteringPage filteringPage;
    private BiomartFilterConfigurationPage filterListPage;
    private BiomartSourcePage sourcePage;
    private MartLocation Database;
    private DatasetInfo Dataset;
    public static final String FORMAT_PLAIN = "TSV";
    public static final String FORMAT_COMPRESSED_GZ = "GZ";
    private FileFormat[] supportedFormats = new FileFormat[]{new FileFormat("Tab Separated Fields", "tsv", "TSV", true, false), new FileFormat("Tab Separated Fields compressed", "tsv.gz", "GZ", true, false)};

    public BiomartTableWizard() {
        this.setTitle("Import table ...");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/BiomartImport.png", (int)96));
        this.setHelpContext("import_biomart");
    }

    public void addPages() {
        this.sourcePage = new BiomartSourcePage();
        this.addPage((IWizardPage)this.sourcePage);
        this.attrListPage = new BiomartAttributeListPage();
        this.attrListPage.setTitle("Select attributes");
        this.addPage((IWizardPage)this.attrListPage);
        this.filterListPage = new BiomartFilterConfigurationPage();
        this.filterListPage.setTitle("Select filters");
        this.addPage((IWizardPage)this.filterListPage);
        this.filteringPage = new BiomartTableFilteringPage();
        this.addPage((IWizardPage)this.filteringPage);
        this.saveFilePage = new SaveFilePage();
        this.saveFilePage.setTitle("Select destination file");
        this.saveFilePage.setFolder(Settings.getDefault().getLastDataPath());
        this.saveFilePage.setFormats(this.supportedFormats);
        this.addPage((IWizardPage)this.saveFilePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.attrListPage) {
            this.biomartService = this.sourcePage.getBiomartService();
            this.Database = this.sourcePage.getDataBase();
            this.Dataset = this.sourcePage.getDataset();
            this.attrListPage.setSource(this.biomartService, this.Database, this.Dataset);
        } else if (nextPage == this.filterListPage) {
            this.biomartConfig = this.attrListPage.getBiomartConfig();
            this.filterListPage.setSource(this.biomartService, this.biomartConfig);
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        IWizardPage page = this.getCurrentPage();
        return canFinish |= page == this.attrListPage && page.isComplete();
    }

    public void performFinish() {
        super.performFinish();
        Settings.getDefault().setLastDataPath(this.saveFilePage.getFolder());
        Settings.getDefault().save();
    }

    public File getSelectedFile() {
        return this.saveFilePage.getPathAsFile();
    }

    public List<AttributeDescription> getAttributeList() {
        return this.attrListPage.getAttributeList();
    }

    public Query getQuery() {
        MartLocation mart = this.getDatabase();
        Dataset ds = new Dataset();
        ds.setName(this.getDataset().getName());
        List dsattrs = ds.getAttribute();
        for (AttributeDescription attrInfo : this.attrListPage.getAttributeList()) {
            Attribute attr = new Attribute();
            attr.setName(attrInfo.getInternalName());
            dsattrs.add(attr);
        }
        List dsFilters = ds.getFilter();
        dsFilters.addAll(this.filterListPage.getFilters());
        Query query = new Query();
        query.setVirtualSchemaName(mart.getServerVirtualSchema());
        query.setHeader(1);
        query.setCount(0);
        query.setUniqueRows(1);
        query.getDatasets().add(ds);
        return query;
    }

    public FileFormat getFormat() {
        return this.saveFilePage.getFormat();
    }

    public boolean isSkipRowsWithEmptyValuesEnabled() {
        return this.filteringPage.isSkipRowsWithEmptyValuesEnabled();
    }

    public String emptyValuesReplacement() {
        return this.filteringPage.emptyValuesReplacement();
    }

    public MartLocation getDatabase() {
        return this.Database;
    }

    public DatasetInfo getDataset() {
        return this.Dataset;
    }

    public BiomartService getService() {
        return this.biomartService;
    }
}

