/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.BiomartServiceException;
import org.gitools.biomart.BiomartServiceFactory;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.biomart.settings.BiomartSource;
import org.gitools.biomart.settings.BiomartSourceManager;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.wizard.common.FilteredListPanel;

public class BiomartSourcePage
extends AbstractWizardPage {
    private BiomartService biomartService;
    private boolean updated;
    private FilteredListPanel datasetPanel;
    private MartLocation lastMartSelected;
    private JPanel dataFilterPanel;
    private JList databaseList;
    private ButtonGroup emptyValuesButtonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JComboBox portalCombo;

    public BiomartSourcePage() {
        this.initComponents();
        this.portalCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BiomartSourcePage.this.updateDatabase();
                }
            }
        });
        this.databaseList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BiomartSourcePage.this.updateDatasets();
            }
        });
        this.datasetPanel = new FilteredListPanel(){

            @Override
            protected void selectionChanged() {
                Object value = BiomartSourcePage.this.datasetPanel.getSelectedValue();
                BiomartSourcePage.this.setComplete(value != null);
            }
        };
        this.datasetPanel.setSelectionMode(0);
        this.dataFilterPanel.setLayout(new BorderLayout());
        this.dataFilterPanel.add((Component)this.datasetPanel, "Center");
        this.updated = false;
        this.setTitle("Select dataset");
    }

    private void initComponents() {
        this.emptyValuesButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.portalCombo = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.databaseList = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.dataFilterPanel = new JPanel();
        this.setBorder(null);
        this.jLabel1.setText("Portal");
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setContinuousLayout(true);
        this.jLabel2.setText("Databases");
        this.jScrollPane1.setViewportBorder(BorderFactory.createEtchedBorder());
        this.databaseList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.databaseList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE).addComponent(this.jLabel2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 328, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jLabel3.setText("Datasets");
        GroupLayout dataFilterPanelLayout = new GroupLayout(this.dataFilterPanel);
        this.dataFilterPanel.setLayout(dataFilterPanelLayout);
        dataFilterPanelLayout.setHorizontalGroup(dataFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 272, Short.MAX_VALUE));
        dataFilterPanelLayout.setVerticalGroup(dataFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 328, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(202, Short.MAX_VALUE)).addComponent(this.dataFilterPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataFilterPanel, -1, -1, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -1, 598, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.portalCombo, 0, 543, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.portalCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jSplitPane1, -1, 363, Short.MAX_VALUE).addContainerGap()));
    }

    public JComponent createControls() {
        return this;
    }

    public void updateControls() {
        if (this.updated) {
            return;
        }
        List sources = BiomartSourceManager.getDefault().getSources();
        DefaultComboBoxModel<BiomartSourceWrapper> sourcesModel = new DefaultComboBoxModel<BiomartSourceWrapper>();
        for (BiomartSource source : sources) {
            sourcesModel.addElement(new BiomartSourceWrapper(source));
        }
        this.portalCombo.setModel(sourcesModel);
        this.updateDatabase();
        this.datasetPanel.setListData(new Object[0]);
        this.datasetPanel.resetFilterText();
    }

    public void updateDatabase() {
        if (this.portalCombo.getSelectedItem() == null) {
            return;
        }
        this.setMessage(MessageStatus.PROGRESS, "Retrieving databases...");
        this.databaseList.setModel(new DefaultListModel());
        this.datasetPanel.setListData(new Object[0]);
        this.datasetPanel.resetFilterText();
        BiomartSource bs = this.getSource();
        if (bs == null) {
            return;
        }
        try {
            this.biomartService = null;
            this.biomartService = BiomartServiceFactory.createService((BiomartSource)bs);
        }
        catch (BiomartServiceException ex) {
            ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            dlg.setVisible(true);
            this.setStatus(MessageStatus.ERROR);
            this.setMessage(ex.getMessage());
        }
        if (this.biomartService == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List registry = BiomartSourcePage.this.biomartService.getRegistry();
                    DefaultListModel<DatabaseListWrapper> model = new DefaultListModel<DatabaseListWrapper>();
                    for (MartLocation mart : registry) {
                        if (mart.getVisible() == 0) continue;
                        model.addElement(new DatabaseListWrapper(mart));
                    }
                    BiomartSourcePage.this.databaseList.setModel(model);
                    BiomartSourcePage.this.updated = true;
                    BiomartSourcePage.this.setMessage(MessageStatus.INFO, "");
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BiomartSourcePage.this.setStatus(MessageStatus.ERROR);
                            BiomartSourcePage.this.setMessage(ex.getMessage());
                        }
                    });
                    ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                    dlg.setVisible(true);
                }
            }
        }).start();
    }

    private void updateDatasets() {
        if (this.databaseList.getSelectedValue() == null || this.lastMartSelected != null && this.lastMartSelected.getName().equals(this.getDataBase().getName())) {
            return;
        }
        this.setMessage(MessageStatus.PROGRESS, "Retrieving datasets...");
        this.datasetPanel.setListData(new Object[0]);
        this.datasetPanel.resetFilterText();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BiomartSourcePage.this.lastMartSelected = BiomartSourcePage.this.getDataBase();
                    List datasets = BiomartSourcePage.this.biomartService.getDatasets(BiomartSourcePage.this.lastMartSelected);
                    ArrayList<DatasetListWrapper> model = new ArrayList<DatasetListWrapper>();
                    for (int i = 0; i < datasets.size(); ++i) {
                        DatasetInfo ds = (DatasetInfo)datasets.get(i);
                        if (ds.getVisible() == 0) continue;
                        model.add(new DatasetListWrapper(ds));
                    }
                    BiomartSourcePage.this.datasetPanel.setListData(model.toArray());
                    BiomartSourcePage.this.updated = true;
                    BiomartSourcePage.this.setMessage(MessageStatus.INFO, "");
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BiomartSourcePage.this.setStatus(MessageStatus.ERROR);
                            BiomartSourcePage.this.setMessage(ex.getMessage());
                        }
                    });
                    ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                    dlg.setVisible(true);
                }
            }
        }).start();
    }

    public BiomartSource getSource() {
        return this.portalCombo.getSelectedItem() != null ? ((BiomartSourceWrapper)this.portalCombo.getSelectedItem()).getBiomartSource() : null;
    }

    public MartLocation getDataBase() {
        return this.databaseList.getSelectedValue() != null ? ((DatabaseListWrapper)this.databaseList.getSelectedValue()).getMart() : null;
    }

    public DatasetInfo getDataset() {
        return this.datasetPanel.getSelectedValue() != null ? ((DatasetListWrapper)this.datasetPanel.getSelectedValue()).getDataset() : null;
    }

    public BiomartService getBiomartService() {
        return this.biomartService;
    }

    private static class DatasetListWrapper {
        private DatasetInfo dataset;

        public DatasetListWrapper(DatasetInfo dataset) {
            this.dataset = dataset;
        }

        public DatasetInfo getDataset() {
            return this.dataset;
        }

        public String toString() {
            return this.dataset.getDisplayName();
        }
    }

    private static class DatabaseListWrapper {
        private MartLocation mart;

        public DatabaseListWrapper(MartLocation mart) {
            this.mart = mart;
        }

        public MartLocation getMart() {
            return this.mart;
        }

        public String toString() {
            return this.mart.getDisplayName();
        }
    }

    private static class BiomartSourceWrapper {
        private BiomartSource source;

        public BiomartSourceWrapper(BiomartSource bs) {
            this.source = bs;
        }

        public BiomartSource getBiomartSource() {
            return this.source;
        }

        public void setBiomartSource(BiomartSource source) {
            this.source = source;
        }

        public String toString() {
            return this.source.getDescription();
        }
    }
}

