/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.io.File;
import java.util.List;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.Attribute;
import org.gitools.biomart.restful.model.Dataset;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.biomart.restful.model.Query;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.ui.biomart.wizard.BiomartAttributePage;
import org.gitools.ui.biomart.wizard.BiomartFilterConfigurationPage;
import org.gitools.ui.biomart.wizard.BiomartSourcePage;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class BiomartModulesWizard
extends AbstractWizard {
    private BiomartAttributePage modulesAttributePage;
    private BiomartAttributePage dataAttributePage;
    private SaveFilePage saveFilePage;
    private BiomartService biomartService;
    private DatasetConfig biomartConfig;
    private BiomartFilterConfigurationPage filterListPage;
    private BiomartSourcePage sourcePage;
    private MartLocation Database;
    private DatasetInfo Dataset;
    public static final String FORMAT_PLAIN = "TSV";
    public static final String FORMAT_COMPRESSED_GZ = "GZ";
    private FileFormat[] supportedFormats = new FileFormat[]{new FileFormat(FileFormats.MODULES_2C_MAP.getTitle(), FileFormats.MODULES_2C_MAP.getExtension(), "TSV", true, false), new FileFormat(FileFormats.MODULES_2C_MAP.getTitle() + " compressed", FileFormats.MODULES_2C_MAP.getExtension() + ".gz", "GZ", true, false)};

    public BiomartModulesWizard() {
        this.setTitle("Import modules...");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/BiomartImport.png", (int)96));
        this.setHelpContext("import_biomart");
    }

    public void addPages() {
        this.sourcePage = new BiomartSourcePage();
        this.addPage((IWizardPage)this.sourcePage);
        this.modulesAttributePage = new BiomartAttributePage();
        this.modulesAttributePage.setId(BiomartAttributePage.class.getCanonicalName() + "1");
        this.modulesAttributePage.setTitle("Select attribute for items");
        this.addPage((IWizardPage)this.modulesAttributePage);
        this.dataAttributePage = new BiomartAttributePage();
        this.dataAttributePage.setId(BiomartAttributePage.class.getCanonicalName() + "2");
        this.dataAttributePage.setTitle("Select attribute for modules");
        this.addPage((IWizardPage)this.dataAttributePage);
        this.filterListPage = new BiomartFilterConfigurationPage();
        this.filterListPage.setTitle("Select filters");
        this.addPage((IWizardPage)this.filterListPage);
        this.saveFilePage = new SaveFilePage();
        this.saveFilePage.setTitle("Select destination file");
        this.saveFilePage.setFolder(Settings.getDefault().getLastMapPath());
        this.saveFilePage.setFormats(this.supportedFormats);
        this.addPage((IWizardPage)this.saveFilePage);
    }

    public void performFinish() {
        Settings.getDefault().setLastMapPath(this.saveFilePage.getFolder());
        Settings.getDefault().save();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.sourcePage) {
            this.biomartService = this.sourcePage.getBiomartService();
            this.Database = this.sourcePage.getDataBase();
            this.Dataset = this.sourcePage.getDataset();
            this.modulesAttributePage.setSource(this.biomartService, this.Database, this.Dataset);
        } else if (page == this.modulesAttributePage) {
            this.dataAttributePage.setAttributePages(this.modulesAttributePage.getAttributePages());
        } else if (page == this.dataAttributePage) {
            this.biomartConfig = this.modulesAttributePage.getBiomartConfig();
            this.filterListPage.setSource(this.biomartService, this.biomartConfig);
        }
        return super.getNextPage(page);
    }

    public File getSelectedFile() {
        return this.saveFilePage.getPathAsFile();
    }

    public Query getQuery() {
        MartLocation mart = this.getDatabase();
        int header = 0;
        int count = 0;
        int uniqueRows = 1;
        Dataset ds = new Dataset();
        ds.setName(this.getDataset().getName());
        Attribute moduleAttr = new Attribute();
        moduleAttr.setName(this.modulesAttributePage.getAttribute().getInternalName());
        Attribute dataAttr = new Attribute();
        dataAttr.setName(this.dataAttributePage.getAttribute().getInternalName());
        ds.getAttribute().add(moduleAttr);
        ds.getAttribute().add(dataAttr);
        List dsFilters = ds.getFilter();
        dsFilters.addAll(this.filterListPage.getFilters());
        Query query = new Query();
        query.setVirtualSchemaName(mart.getServerVirtualSchema());
        query.setHeader(header);
        query.setCount(count);
        query.setUniqueRows(uniqueRows);
        query.getDatasets().add(ds);
        return query;
    }

    public FileFormat getFormat() {
        return this.saveFilePage.getFormat();
    }

    public MartLocation getDatabase() {
        return this.Database;
    }

    public DatasetInfo getDataset() {
        return this.Dataset;
    }

    public BiomartService getService() {
        return this.biomartService;
    }
}

