/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterCollection;
import org.gitools.biomart.restful.model.FilterGroup;
import org.gitools.biomart.restful.model.FilterPage;
import org.gitools.biomart.restful.model.Option;
import org.gitools.ui.biomart.filter.FilterCollectionPanel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class BiomartFilterConfigurationPage
extends AbstractWizardPage {
    private final Integer FILTER_PANEL_WEIGHT = 333;
    private final Integer FILTER_PANEL_HEIGHT = 330;
    private DatasetInfo dataset;
    private DatasetConfig biomartConfig;
    private BiomartService biomartService;
    private FilterGroup lastGroupSelected;
    private FilterPage lastPageSelected;
    private HashMap<String, Filter> filters;
    private HashMap<FilterPage, CollectionsPanelsCache> collectionsCache;
    private Boolean reloadData;
    private HashMap<String, List<Option>> defaultSelecComposData;
    private JPanel collectionsPanel;
    private JList filterGroupList;
    private JComboBox filterPageCombo;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSplitPane jSplitPane1;
    private JScrollPane scrollPanel;

    public BiomartFilterConfigurationPage() {
        this.initComponents();
        this.lastGroupSelected = null;
        this.lastPageSelected = null;
        this.reloadData = true;
        this.filters = new HashMap();
        this.collectionsCache = new HashMap();
        this.setComplete(true);
        this.filterPageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && BiomartFilterConfigurationPage.this.filterPageCombo.getSelectedItem() != null) {
                    BiomartFilterConfigurationPage.this.updateGroupFilterList(((PageListWrapper)BiomartFilterConfigurationPage.this.filterPageCombo.getSelectedItem()).getFilterPage());
                    BiomartFilterConfigurationPage.this.lastPageSelected = ((PageListWrapper)BiomartFilterConfigurationPage.this.filterPageCombo.getSelectedItem()).getFilterPage();
                }
            }
        });
        this.filterGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (BiomartFilterConfigurationPage.this.filterPageCombo.getModel().getSelectedItem() != null && BiomartFilterConfigurationPage.this.filterGroupList.getSelectedValue() != null) {
                    BiomartFilterConfigurationPage.this.updateCollectionControls(((PageListWrapper)BiomartFilterConfigurationPage.this.filterPageCombo.getModel().getSelectedItem()).getFilterPage(), ((GroupListWrapper)BiomartFilterConfigurationPage.this.filterGroupList.getSelectedValue()).getFilterGroup());
                    BiomartFilterConfigurationPage.this.lastGroupSelected = ((GroupListWrapper)BiomartFilterConfigurationPage.this.filterGroupList.getSelectedValue()).getFilterGroup();
                }
            }
        });
    }

    private void initComponents() {
        this.filterPageCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.filterGroupList = new JList();
        this.jPanel2 = new JPanel();
        this.scrollPanel = new JScrollPane();
        this.collectionsPanel = new JPanel();
        this.setBorder(null);
        this.jLabel1.setText("Page");
        this.jSplitPane1.setDividerLocation(198);
        this.jSplitPane1.setContinuousLayout(true);
        this.filterGroupList.setSelectionMode(0);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.filterGroupList, -1, 186, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.filterGroupList, -1, 366, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.scrollPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollPanel.setViewportBorder(null);
        this.collectionsPanel.setBorder(null);
        GroupLayout collectionsPanelLayout = new GroupLayout(this.collectionsPanel);
        this.collectionsPanel.setLayout(collectionsPanelLayout);
        collectionsPanelLayout.setHorizontalGroup(collectionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        collectionsPanelLayout.setVerticalGroup(collectionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 366, Short.MAX_VALUE));
        this.scrollPanel.setViewportView(this.collectionsPanel);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 362, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanel, -1, 350, Short.MAX_VALUE))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 390, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanel, -1, 366, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -1, 566, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterPageCombo, 0, 522, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.filterPageCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 390, Short.MAX_VALUE).addContainerGap()));
    }

    public JComponent createControls() {
        return this;
    }

    public void updateControls() {
        this.collectionsPanel.removeAll();
        this.collectionsPanel.setPreferredSize(new Dimension(this.FILTER_PANEL_WEIGHT, this.FILTER_PANEL_HEIGHT));
        this.filterGroupList.clearSelection();
        this.lastGroupSelected = null;
        this.lastPageSelected = null;
        if (this.reloadData.booleanValue()) {
            this.setMessage(MessageStatus.PROGRESS, "Retrieving available filters ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        BiomartFilterConfigurationPage.this.defaultSelecComposData = new HashMap();
                        BiomartFilterConfigurationPage.this.initCollectionsCache();
                        BiomartFilterConfigurationPage.this.updatePageFilterList();
                        if (BiomartFilterConfigurationPage.this.filterPageCombo.getSelectedItem() != null) {
                            BiomartFilterConfigurationPage.this.lastPageSelected = ((PageListWrapper)BiomartFilterConfigurationPage.this.filterPageCombo.getSelectedItem()).getFilterPage();
                            BiomartFilterConfigurationPage.this.setMessage(MessageStatus.INFO, "");
                        } else {
                            BiomartFilterConfigurationPage.this.lastPageSelected = null;
                            BiomartFilterConfigurationPage.this.setMessage(MessageStatus.INFO, " No filters are availables");
                        }
                        BiomartFilterConfigurationPage.this.reloadData = false;
                    }
                    catch (Exception ex) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BiomartFilterConfigurationPage.this.setStatus(MessageStatus.ERROR);
                                BiomartFilterConfigurationPage.this.setMessage(ex.getMessage());
                            }
                        });
                        ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                        dlg.setVisible(true);
                        System.out.println(ex);
                    }
                }
            }).start();
        }
    }

    public void updatePageFilterList() {
        DefaultComboBoxModel<PageListWrapper> model = new DefaultComboBoxModel<PageListWrapper>();
        if (this.biomartConfig.getFilterPages() != null) {
            for (FilterPage p : this.biomartConfig.getFilterPages()) {
                if (p.isHidden() || p.isHideDisplay()) continue;
                model.addElement(new PageListWrapper(p));
                this.updateGroupFilterList(p);
            }
        }
        this.filterPageCombo.setModel(model);
    }

    private void updateGroupFilterList(FilterPage page) {
        if (this.lastPageSelected != null && this.lastPageSelected.getInternalName().equals(page.getInternalName())) {
            return;
        }
        this.collectionsPanel.removeAll();
        this.collectionsPanel.setPreferredSize(new Dimension(this.FILTER_PANEL_WEIGHT, this.FILTER_PANEL_HEIGHT));
        this.lastGroupSelected = null;
        DefaultListModel<GroupListWrapper> model = new DefaultListModel<GroupListWrapper>();
        for (FilterGroup group : page.getFilterGroups()) {
            if (group.isHidden() || group.isHideDisplay()) continue;
            model.addElement(new GroupListWrapper(group));
            this.updateCollectionsCache(page, group);
        }
        this.filterGroupList.setModel(model);
    }

    private void updateCollectionsCache(FilterPage page, FilterGroup group) {
        FilterCollectionPanel collectionPanel = null;
        ArrayList<FilterCollectionPanel> listCollections = new ArrayList<FilterCollectionPanel>();
        for (FilterCollection collection : group.getFilterCollections()) {
            if (collection.isHidden() || collection.isHideDisplay() || !(collectionPanel = new FilterCollectionPanel(collection, this)).isPanelRendered().booleanValue()) continue;
            listCollections.add(collectionPanel);
        }
        this.collectionsCache.get((Object)page).collections.put(group, listCollections);
    }

    private void updateCollectionControls(FilterPage page, FilterGroup group) {
        if (this.filterGroupList.getSelectedValue() == null || this.lastGroupSelected != null && this.lastGroupSelected.getInternalName().equals(group.getInternalName())) {
            return;
        }
        Integer collectionPanelHeight = 0;
        this.collectionsPanel.removeAll();
        this.collectionsPanel.repaint();
        this.collectionsPanel.setLayout(new BoxLayout(this.collectionsPanel, 1));
        if (this.collectionsCache.get((Object)page).collections.get(group).size() == 0) {
            this.updateCollectionsCache(page, group);
        }
        for (FilterCollectionPanel col : this.collectionsCache.get((Object)page).collections.get(group)) {
            this.collectionsPanel.add(col);
            collectionPanelHeight = collectionPanelHeight + col.getCurrentHeigh();
        }
        Dimension d = new Dimension(this.collectionsPanel.getWidth(), collectionPanelHeight);
        this.collectionsPanel.setPreferredSize(d);
        this.collectionsPanel.repaint();
        this.scrollPanel.validate();
        this.validate();
    }

    public Collection<Filter> getFilters() {
        ArrayList<Filter> listFilters = new ArrayList<Filter>();
        for (FilterPage page : this.collectionsCache.keySet()) {
            for (FilterGroup group : this.collectionsCache.get((Object)page).collections.keySet()) {
                for (FilterCollectionPanel panel : this.collectionsCache.get((Object)page).collections.get(group)) {
                    listFilters.addAll(panel.getFilters());
                }
            }
        }
        return listFilters;
    }

    public void setSource(BiomartService service, DatasetConfig config) {
        if (this.biomartConfig != null && this.biomartConfig.getDataset().equals(config.getDataset())) {
            this.reloadData = false;
        } else {
            this.reloadData = true;
            this.filterPageCombo.setModel(new DefaultComboBoxModel());
            this.filterGroupList.setModel(new DefaultListModel());
            this.collectionsPanel.removeAll();
            this.collectionsPanel.repaint();
            this.scrollPanel.validate();
            this.validate();
        }
        this.biomartService = service;
        this.biomartConfig = config;
    }

    private void initCollectionsCache() {
        if (this.collectionsCache == null) {
            this.collectionsCache = new HashMap();
        } else {
            this.collectionsCache.clear();
        }
        for (FilterPage page : this.biomartConfig.getFilterPages()) {
            if (page.isHidden() || page.isHideDisplay()) continue;
            this.collectionsCache.put(page, null);
            CollectionsPanelsCache panels = new CollectionsPanelsCache();
            for (FilterGroup group : page.getFilterGroups()) {
                panels.collections.put(group, new ArrayList(0));
            }
            this.collectionsCache.put(page, panels);
        }
    }

    public void setFilter(String name, Filter f) {
        this.filters.put(name, f);
    }

    public void setFilters(HashMap<String, Filter> filters) {
        filters.putAll(filters);
    }

    public void deleteFilter(String name) {
        this.filters.remove(name);
    }

    public void deleteFilters(HashMap<String, Filter> delFilters) {
        for (String name : delFilters.keySet()) {
            this.filters.remove(name);
        }
    }

    public BiomartService getBiomartService() {
        return this.biomartService;
    }

    public DatasetConfig getDatasetConfig() {
        return this.biomartConfig;
    }

    public HashMap<FilterPage, CollectionsPanelsCache> getCollectionsCache() {
        return this.collectionsCache;
    }

    public void setCollectionsCache(HashMap<FilterPage, CollectionsPanelsCache> collectionsCache) {
        this.collectionsCache = collectionsCache;
    }

    public HashMap<String, List<Option>> getDefaultSelecComposData() {
        return this.defaultSelecComposData;
    }

    public void storeSelecComponentsDefaultData(HashMap<String, List<Option>> data) {
        if (data.size() > 0) {
            for (String key : data.keySet()) {
                this.defaultSelecComposData.put(key, data.get(key));
            }
        }
    }

    public static class CollectionsPanelsCache {
        public HashMap<FilterGroup, List<FilterCollectionPanel>> collections = new HashMap();
    }

    private static class GroupListWrapper {
        private FilterGroup group;

        public GroupListWrapper(FilterGroup dataset) {
            this.group = dataset;
        }

        public FilterGroup getFilterGroup() {
            return this.group;
        }

        public String toString() {
            String res = this.group.getDisplayName();
            if (res != null) {
                res = res.replace(":", "");
            }
            return res;
        }
    }

    private static class PageListWrapper {
        private FilterPage page;

        public PageListWrapper(FilterPage dataset) {
            this.page = dataset;
        }

        public FilterPage getFilterPage() {
            return this.page;
        }

        public String toString() {
            String res = this.page.getDisplayName();
            if (res != null) {
                res = res.replace(":", "");
            }
            return res;
        }
    }
}

