/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.wizard.common.FilteredListPanel;

public class BiomartDatasetPage
extends AbstractWizardPage {
    private final BiomartService biomartService;
    private MartLocation mart;
    private FilteredListPanel panelDataset;
    private boolean updated;

    public BiomartDatasetPage(BiomartService biomartService) {
        this.biomartService = biomartService;
        this.mart = null;
        this.updated = false;
        this.setTitle("Select dataset");
    }

    public JComponent createControls() {
        this.panelDataset = new FilteredListPanel();
        this.panelDataset.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BiomartDatasetPage.this.selectionChangeActionPerformed();
            }
        });
        return this.panelDataset;
    }

    public void updateControls() {
        if (this.mart == null) {
            return;
        }
        if (this.updated) {
            return;
        }
        this.setStatus(MessageStatus.PROGRESS);
        this.setMessage("Retrieving datasets for " + this.mart.getDisplayName() + " ...");
        this.panelDataset.setListData(new Object[0]);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List dataSets = BiomartDatasetPage.this.biomartService.getDatasets(BiomartDatasetPage.this.mart);
                    final ArrayList<DatasetListWrapper> visibleDataSets = new ArrayList<DatasetListWrapper>();
                    for (DatasetInfo ds : dataSets) {
                        if (ds.getVisible() == 0) continue;
                        visibleDataSets.add(new DatasetListWrapper(ds));
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            BiomartDatasetPage.this.panelDataset.setListData(visibleDataSets.toArray(new DatasetListWrapper[visibleDataSets.size()]));
                            BiomartDatasetPage.this.setMessage(MessageStatus.INFO, "");
                        }
                    });
                    BiomartDatasetPage.this.updated = true;
                }
                catch (Exception e) {
                    BiomartDatasetPage.this.setStatus(MessageStatus.ERROR);
                    BiomartDatasetPage.this.setMessage(e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void setMart(MartLocation mart) {
        if (this.mart != mart) {
            this.updated = false;
        }
        this.mart = mart;
    }

    public DatasetInfo getDataset() {
        DatasetListWrapper wrapper = (DatasetListWrapper)this.panelDataset.getSelectedValue();
        return wrapper.getDataset();
    }

    private void selectionChangeActionPerformed() {
        Object value = this.panelDataset.list.getSelectedValue();
        this.setComplete(value != null);
    }

    private static class DatasetListWrapper {
        private DatasetInfo dataset;

        public DatasetListWrapper(DatasetInfo dataset) {
            this.dataset = dataset;
        }

        public DatasetInfo getDataset() {
            return this.dataset;
        }

        public String toString() {
            return this.dataset.getDisplayName();
        }
    }
}

