/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.wizard.common.FilteredListPanel;

public class BiomartDatabasePage
extends AbstractWizardPage {
    private BiomartService biomartService;
    private FilteredListPanel panelDataset;
    private boolean updated;

    public BiomartDatabasePage(BiomartService biomartService) {
        this.biomartService = biomartService;
        this.updated = false;
        this.setTitle("Select database");
    }

    public JComponent createControls() {
        this.panelDataset = new FilteredListPanel();
        this.panelDataset.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BiomartDatabasePage.this.selectionChangeActionPerformed();
            }
        });
        return this.panelDataset;
    }

    public void updateControls() {
        if (this.updated) {
            return;
        }
        this.setMessage(MessageStatus.PROGRESS, "Retrieving databases...");
        this.panelDataset.setListData(new Object[0]);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List registry = BiomartDatabasePage.this.biomartService.getRegistry();
                    final ArrayList<DatabaseListWrapper> listData = new ArrayList<DatabaseListWrapper>();
                    for (MartLocation mart : registry) {
                        if (mart.getVisible() == 0) continue;
                        listData.add(new DatabaseListWrapper(mart));
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            BiomartDatabasePage.this.panelDataset.setListData(listData.toArray(new DatabaseListWrapper[listData.size()]));
                            BiomartDatabasePage.this.setMessage(MessageStatus.INFO, "");
                        }
                    });
                    BiomartDatabasePage.this.updated = true;
                }
                catch (Exception e) {
                    BiomartDatabasePage.this.setStatus(MessageStatus.ERROR);
                    BiomartDatabasePage.this.setMessage(e.getMessage());
                    ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)e);
                    dlg.setVisible(true);
                }
            }
        }).start();
    }

    public MartLocation getMart() {
        DatabaseListWrapper model = (DatabaseListWrapper)this.panelDataset.getSelectedValue();
        return model.getMart();
    }

    private void selectionChangeActionPerformed() {
        Object value = this.panelDataset.list.getSelectedValue();
        this.setComplete(value != null);
    }

    private static class DatabaseListWrapper {
        private MartLocation mart;

        public DatabaseListWrapper(MartLocation mart) {
            this.mart = mart;
        }

        public MartLocation getMart() {
            return this.mart;
        }

        public String toString() {
            return this.mart.getDisplayName();
        }
    }
}

