/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.ui.biomart.panel.AttributesTreeModel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.wizard.common.FilteredTreePage;
import org.gitools.ui.wizard.common.FilteredTreePanel;

public class BiomartAttributePage
extends FilteredTreePage {
    private MartLocation mart = null;
    private DatasetInfo dataset = null;
    private List<AttributePage> attrPages = null;
    private AttributeDescription attribute;
    private BiomartService biomartService;
    private DatasetConfig biomartConfig;
    private Boolean reloadData;

    @Override
    public JComponent createControls() {
        JComponent component = super.createControls();
        this.panel.tree.setRootVisible(false);
        this.panel.tree.getSelectionModel().setSelectionMode(1);
        this.panel.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BiomartAttributePage.this.selectionChanged();
            }
        });
        return component;
    }

    public void updateControls() {
        this.setComplete(false);
        this.panel.setModel(new AttributesTreeModel(new ArrayList<AttributePage>(0)));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (BiomartAttributePage.this.attrPages == null || BiomartAttributePage.this.reloadData.booleanValue()) {
                        BiomartAttributePage.this.setStatus(MessageStatus.PROGRESS);
                        BiomartAttributePage.this.setMessage("Retrieving available attributes ...");
                        BiomartAttributePage.this.biomartConfig = BiomartAttributePage.this.biomartService.getConfiguration(BiomartAttributePage.this.dataset);
                        BiomartAttributePage.this.attrPages = BiomartAttributePage.this.biomartConfig.getAttributePages();
                    }
                    final AttributesTreeModel model = new AttributesTreeModel(BiomartAttributePage.this.attrPages);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FilteredTreePanel p = BiomartAttributePage.this.getPanel();
                            p.setModel(model);
                            p.expandAll();
                            BiomartAttributePage.this.setMessage(MessageStatus.INFO, "");
                        }
                    });
                }
                catch (Throwable cause) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BiomartAttributePage.this.setStatus(MessageStatus.ERROR);
                            BiomartAttributePage.this.setMessage(cause.getClass().getSimpleName() + ": " + cause.getMessage());
                            ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), cause);
                            dlg.setVisible(true);
                        }
                    });
                }
            }
        }).start();
    }

    private void selectionChanged() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.panel.tree.getLastSelectedPathComponent();
        boolean complete = false;
        if (node != null && node.getUserObject() instanceof AttributesTreeModel.AttributeWrapper) {
            AttributesTreeModel.AttributeWrapper aw = (AttributesTreeModel.AttributeWrapper)node.getUserObject();
            boolean bl = complete = aw.getType() == AttributesTreeModel.AttributeWrapper.NodeType.ATTRIBUTE;
            if (complete) {
                this.attribute = (AttributeDescription)aw.getObject();
            }
        }
        this.setComplete(complete);
    }

    public void setSource(BiomartService biomartService, MartLocation mart, DatasetInfo dataset) {
        this.reloadData = this.dataset != null && this.dataset.getName().equals(dataset.getName()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.biomartService = biomartService;
        this.mart = mart;
        this.dataset = dataset;
    }

    public synchronized void setAttributePages(List<AttributePage> attrPages) {
        this.attrPages = attrPages;
        this.reloadData = false;
    }

    public synchronized List<AttributePage> getAttributePages() {
        return this.attrPages;
    }

    public AttributeDescription getAttribute() {
        return this.attribute;
    }

    @Override
    protected TreeModel createModel(String filterText) {
        return new AttributesTreeModel(this.attrPages, filterText);
    }

    public DatasetConfig getBiomartConfig() {
        return this.biomartConfig;
    }
}

