/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.wizard;

import java.awt.Window;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.ui.biomart.panel.BiomartAttributeListPanel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class BiomartAttributeListPage
extends AbstractWizardPage {
    private MartLocation mart;
    private DatasetInfo dataset;
    private List<AttributePage> attrPages;
    private BiomartAttributeListPanel panel;
    private BiomartService biomartService;
    private DatasetConfig biomartConfig;
    private Boolean reloadData;

    public JComponent createControls() {
        this.panel = new BiomartAttributeListPanel();
        this.panel.addAttributeListChangeListener(new BiomartAttributeListPanel.AttributeListChangeListener(){

            @Override
            public void listChanged() {
                BiomartAttributeListPage.this.setComplete(BiomartAttributeListPage.this.panel.getAttributeListSize() > 0);
            }
        });
        return this.panel;
    }

    public void updateControls() {
        if (this.panel != null && this.reloadData.booleanValue()) {
            this.panel.removeAllListAttributes();
        }
        this.panel.setAttributePages(null);
        if (this.panel.getAttributePages() == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BiomartAttributeListPage.this.updateControlsThread();
                    BiomartAttributeListPage.this.reloadData = false;
                }
            }).start();
        }
    }

    private void updateControlsThread() {
        try {
            if (this.attrPages == null || this.reloadData.booleanValue()) {
                this.setStatus(MessageStatus.PROGRESS);
                this.setMessage("Retrieving available attributes ...");
                this.biomartConfig = this.biomartService.getConfiguration(this.dataset);
                this.attrPages = this.biomartConfig.getAttributePages();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BiomartAttributeListPage.this.panel.setAttributePages(BiomartAttributeListPage.this.attrPages);
                    BiomartAttributeListPage.this.setStatus(MessageStatus.WARN);
                    BiomartAttributeListPage.this.setMessage("Press [Add...] button to select attributes");
                }
            });
        }
        catch (Throwable cause) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BiomartAttributeListPage.this.setStatus(MessageStatus.ERROR);
                    BiomartAttributeListPage.this.setMessage(cause.getClass().getSimpleName() + ": " + cause.getMessage());
                    ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), cause);
                    dlg.setVisible(true);
                }
            });
        }
    }

    public void setSource(BiomartService biomartService, MartLocation mart, DatasetInfo ds) {
        this.reloadData = this.dataset != null && this.dataset.getName().equals(ds.getName()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.biomartService = biomartService;
        this.mart = mart;
        this.dataset = ds;
    }

    public List<AttributeDescription> getAttributeList() {
        return this.panel.getAttributeList();
    }

    public DatasetConfig getBiomartConfig() {
        return this.biomartConfig;
    }
}

