/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.panel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.BiomartServiceFactory;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.biomart.settings.BiomartSource;
import org.gitools.biomart.settings.BiomartSourceManager;
import org.gitools.ui.biomart.panel.AttributesTreeModel;
import org.gitools.ui.wizard.common.FilteredTreePanel;

public class BiomartAttributePanel
extends FilteredTreePanel {
    private BiomartService port = null;
    private MartLocation mart = null;
    private DatasetInfo dataset = null;
    private List<AttributePage> attrPages = null;
    private List<AttributeDescription> selectedAttr;
    private List<String> selectedAttrNames;
    private Set<String> selectedAttrNamesSet;
    private List<AttributeSelectionListener> attributeSelectionListeners = new ArrayList<AttributeSelectionListener>();

    public BiomartAttributePanel() {
        this.selectedAttr = new ArrayList<AttributeDescription>();
        this.selectedAttrNames = new ArrayList<String>();
        this.selectedAttrNamesSet = new HashSet<String>();
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BiomartAttributePanel.this.selectionChanged(e);
            }
        });
    }

    public void setBiomartParameters(BiomartService port, MartLocation mart, DatasetInfo dataset) {
        this.port = port;
        this.mart = mart;
        this.dataset = dataset;
        this.loadAttributePages();
    }

    private void loadAttributePages() {
        this.setControlsEnabled(false);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Loading...");
        DefaultTreeModel model = new DefaultTreeModel(node);
        this.setModel(model);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BiomartAttributePanel.this.loadingThread();
            }
        }).start();
    }

    public List<AttributeDescription> getSelectedAttributes() {
        return this.selectedAttr;
    }

    public List<String> getSelectedAttributeNames() {
        return this.selectedAttrNames;
    }

    private void loadingThread() {
        try {
            List lBs = BiomartSourceManager.getDefault().getSources();
            BiomartSource bsrc = (BiomartSource)lBs.get(0);
            BiomartService service = BiomartServiceFactory.createService((BiomartSource)bsrc);
            final List pages = service.getAttributes(this.mart, this.dataset);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BiomartAttributePanel.this.setControlsEnabled(true);
                    BiomartAttributePanel.this.setAttributePages(pages);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectionChanged(TreeSelectionEvent e) {
        TreePath[] paths = e.getPaths();
        if (paths == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (TreePath sel : paths) {
            AttributeDescription attribute;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getLastPathComponent();
            AttributesTreeModel.AttributeWrapper attrw = (AttributesTreeModel.AttributeWrapper)node.getUserObject();
            AttributeDescription attributeDescription = attribute = attrw.getType() == AttributesTreeModel.AttributeWrapper.NodeType.ATTRIBUTE ? (AttributeDescription)attrw.getObject() : null;
            if (e.isAddedPath(sel)) {
                if (attribute != null) {
                    if (this.selectedAttrNamesSet.contains(attribute.getInternalName())) continue;
                    sb.setLength(0);
                    Object[] opath = sel.getPath();
                    if (opath.length > 1) {
                        sb.append(opath[1].toString());
                        for (int i = 2; i < opath.length; ++i) {
                            sb.append(" > ").append(opath[i].toString());
                        }
                    }
                    this.selectedAttr.add(attribute);
                    this.selectedAttrNames.add(sb.toString());
                    this.selectedAttrNamesSet.add(attribute.getInternalName());
                    for (AttributeSelectionListener l : this.attributeSelectionListeners) {
                        l.selectionChanged();
                    }
                    continue;
                }
                this.tree.getSelectionModel().removeSelectionPath(sel);
                continue;
            }
            if (attribute == null) continue;
            int i = this.selectedAttr.indexOf(attribute);
            this.selectedAttr.remove(i);
            this.selectedAttrNames.remove(i);
            this.selectedAttrNamesSet.remove(attribute.getInternalName());
            for (AttributeSelectionListener l : this.attributeSelectionListeners) {
                l.selectionChanged();
            }
        }
    }

    public void addAttributeSelectionListener(AttributeSelectionListener listener) {
        this.attributeSelectionListeners.add(listener);
    }

    public void removeAttributeSelectionListener(AttributeSelectionListener listener) {
        this.attributeSelectionListeners.remove(listener);
    }

    private void setControlsEnabled(boolean enabled) {
        this.filterField.setEnabled(enabled);
    }

    @Override
    protected TreeModel updateModel(String filterText) {
        if (this.attrPages == null) {
            return null;
        }
        return new AttributesTreeModel(this.attrPages, filterText);
    }

    public synchronized void setAttributePages(List<AttributePage> attrPages) {
        this.attrPages = attrPages;
        AttributesTreeModel model = attrPages == null ? null : new AttributesTreeModel(attrPages);
        this.setModel(model);
        this.expandAll();
    }

    public synchronized List<AttributePage> getAttributePages() {
        return this.attrPages;
    }

    public static interface AttributeSelectionListener {
        public void selectionChanged();
    }
}

