/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.panel;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.biomart.restful.model.AttributeCollection;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributeGroup;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.ui.biomart.dialog.BiomartAttributeDialog;
import org.gitools.ui.platform.AppFrame;

public class BiomartAttributeListPanel
extends JPanel {
    private List<AttributePage> attrPages;
    private List<AttributeListChangeListener> attributeListChangeListeners = new ArrayList<AttributeListChangeListener>();
    private JButton addBtn;
    private JList attrList;
    private JButton downBtn;
    private JScrollPane jScrollPane1;
    private JButton loadBtn;
    private JButton removeBtn;
    private JButton saveBtn;
    private JButton upBtn;

    public BiomartAttributeListPanel() {
        this.initComponents();
        this.attrList.setModel(new DefaultListModel());
        this.attrList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BiomartAttributeListPanel.this.updateButtons();
                for (AttributeListChangeListener l : BiomartAttributeListPanel.this.attributeListChangeListeners) {
                    l.listChanged();
                }
            }
        });
        this.attrList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BiomartAttributeListPanel.this.updateButtons();
                for (AttributeListChangeListener l : BiomartAttributeListPanel.this.attributeListChangeListeners) {
                    l.listChanged();
                }
            }
        });
        this.updateButtons();
    }

    public List<AttributePage> getAttributePages() {
        return this.attrPages;
    }

    public void setAttributePages(List<AttributePage> attrPages) {
        this.attrPages = attrPages;
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        if (model.size() == 0 && attrPages != null) {
            for (AttributePage p : attrPages) {
                for (AttributeGroup g : p.getAttributeGroups()) {
                    for (AttributeCollection c : g.getAttributeCollections()) {
                        for (AttributeDescription d : c.getAttributeDescriptions()) {
                            if (d.isHidden() || d.isHideDisplay() || !d.isDefault()) continue;
                            model.addElement(new AttributeDescWrapper(d, p.getDisplayName() + " > " + g.getDisplayName() + " > " + c.getDisplayName() + " > " + d.getDisplayName()));
                        }
                    }
                }
            }
        }
        this.updateButtons();
    }

    public void addAttributeListChangeListener(AttributeListChangeListener listener) {
        this.attributeListChangeListeners.add(listener);
    }

    public void removeAttributeListChangeListener(AttributeListChangeListener listener) {
        this.attributeListChangeListeners.remove(listener);
    }

    @Deprecated
    public void setAddBtnEnabled(boolean enabled) {
        this.addBtn.setEnabled(enabled);
    }

    public void updateButtons() {
        this.addBtn.setEnabled(this.attrPages != null);
        int len = this.attrList.getModel().getSize();
        int selIndex = this.attrList.getSelectedIndex();
        this.removeBtn.setEnabled(len > 0);
        this.upBtn.setEnabled(selIndex > 0);
        this.downBtn.setEnabled(len > 1 && selIndex < len - 1);
        this.loadBtn.setEnabled(false);
        this.saveBtn.setEnabled(false);
    }

    public int getAttributeListSize() {
        return this.attrList.getModel().getSize();
    }

    public List<AttributeDescription> getAttributeList() {
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        Enumeration e = model.elements();
        ArrayList<AttributeDescription> list = new ArrayList<AttributeDescription>(model.getSize());
        while (e.hasMoreElements()) {
            list.add(((AttributeDescWrapper)e.nextElement()).getAttribute());
        }
        return list;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.attrList = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.loadBtn = new JButton();
        this.saveBtn = new JButton();
        this.jScrollPane1.setViewportView(this.attrList);
        this.addBtn.setText("Add...");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.addBtnActionPerformed(evt);
            }
        });
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.removeBtnActionPerformed(evt);
            }
        });
        this.upBtn.setText("Up");
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.upBtnActionPerformed(evt);
            }
        });
        this.downBtn.setText("Down");
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.downBtnActionPerformed(evt);
            }
        });
        this.loadBtn.setText("Load...");
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.loadBtnActionPerformed(evt);
            }
        });
        this.saveBtn.setText("Save...");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeListPanel.this.saveBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.saveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.loadBtn, -1, -1, Short.MAX_VALUE).addComponent(this.removeBtn, -1, -1, Short.MAX_VALUE).addComponent(this.upBtn, -1, -1, Short.MAX_VALUE).addComponent(this.downBtn, -1, -1, Short.MAX_VALUE).addComponent(this.addBtn, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn))).addContainerGap()));
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        BiomartAttributeDialog dlg = new BiomartAttributeDialog((Frame)AppFrame.instance(), this.attrPages);
        dlg.open();
        if (!dlg.isCancelled()) {
            List<AttributeDescription> attributes = dlg.getSelectedAttributes();
            List<String> names = dlg.getSelectedAttributeNames();
            if (attributes != null && attributes.size() > 0) {
                DefaultListModel model = (DefaultListModel)this.attrList.getModel();
                for (int i = 0; i < attributes.size(); ++i) {
                    model.addElement(new AttributeDescWrapper(attributes.get(i), names.get(i)));
                }
            }
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        Object[] objects;
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        for (Object o : objects = this.attrList.getSelectedValues()) {
            model.removeElement(o);
        }
    }

    public void removeAllListAttributes() {
        if (this.attrList.getModel() == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        if (model != null) {
            model.removeAllElements();
        }
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        int[] indices = this.attrList.getSelectedIndices();
        int pos = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            pos = pos > indices[i] ? indices[i] : pos;
        }
        if (--pos >= 0 && pos < model.getSize()) {
            Object[] objects = this.attrList.getSelectedValues();
            int i = 0;
            for (Object o : objects) {
                model.removeElement(o);
                indices[i++] = pos;
                model.insertElementAt(o, pos++);
            }
            this.attrList.setSelectedIndices(indices);
        }
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.attrList.getModel();
        int[] indices = this.attrList.getSelectedIndices();
        int pos = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            pos = pos > indices[i] ? indices[i] : pos;
        }
        if (++pos >= 0 && pos + indices.length <= model.getSize()) {
            Object[] objects;
            for (Object o : objects = this.attrList.getSelectedValues()) {
                model.removeElement(o);
            }
            int i = 0;
            for (int j = objects.length - 1; j >= 0; --j) {
                Object o = objects[j];
                model.insertElementAt(o, pos);
                indices[i++] = pos + j;
            }
            this.attrList.setSelectedIndices(indices);
        }
    }

    private void loadBtnActionPerformed(ActionEvent evt) {
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
    }

    private static class AttributeDescWrapper {
        private AttributeDescription attr;
        private String label;

        public AttributeDescWrapper(AttributeDescription attr, String label) {
            this.attr = attr;
            this.label = label;
        }

        public AttributeDescription getAttribute() {
            return this.attr;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface AttributeListChangeListener {
        public void listChanged();
    }
}

