/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.panel;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.gitools.biomart.restful.model.AttributeCollection;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributeGroup;
import org.gitools.biomart.restful.model.AttributePage;

public class AttributesTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 8325493802045161663L;

    public AttributesTreeModel(List<AttributePage> pages) {
        this(pages, "");
    }

    public AttributesTreeModel(List<AttributePage> pages, String filterText) {
        super(new DefaultMutableTreeNode("root"));
        filterText = filterText.toLowerCase();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        for (AttributePage page : pages) {
            DefaultMutableTreeNode pageNode;
            if (page.isHidden() || page.isHideDisplay() || !page.getOutFormats().toLowerCase().contains("tsv") || this.populatePage(pageNode = new DefaultMutableTreeNode(new AttributeWrapper(page)), page.getAttributeGroups(), filterText) <= 0) continue;
            node.add(pageNode);
        }
    }

    private int populatePage(DefaultMutableTreeNode node, List<AttributeGroup> groups, String filterText) {
        for (AttributeGroup group : groups) {
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(new AttributeWrapper(group));
            if (this.populateGroup(groupNode, group.getAttributeCollections(), filterText) <= 0) continue;
            node.add(groupNode);
        }
        return node.getChildCount();
    }

    private int populateGroup(DefaultMutableTreeNode node, List<AttributeCollection> collections, String filterText) {
        for (AttributeCollection coll : collections) {
            DefaultMutableTreeNode collNode = new DefaultMutableTreeNode(new AttributeWrapper(coll));
            if (this.populateCollection(collNode, coll.getAttributeDescriptions(), filterText) <= 0) continue;
            node.add(collNode);
        }
        return node.getChildCount();
    }

    private int populateCollection(DefaultMutableTreeNode node, List<AttributeDescription> attrs, String filterText) {
        for (AttributeDescription attr : attrs) {
            if (attr.getDisplayName() == null) continue;
            AttributeWrapper aw = new AttributeWrapper(attr);
            if (!filterText.isEmpty() && !aw.getName().toLowerCase().contains(filterText)) continue;
            node.add(new DefaultMutableTreeNode(aw));
        }
        return node.getChildCount();
    }

    public static class AttributeWrapper {
        private Object object;
        private NodeType type;
        private String name;

        public AttributeWrapper(Object object) {
            this.object = object;
            this.type = this.nodeType(object);
            this.name = this.nodeName(object, this.type);
            if (this.name.endsWith(":")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }

        private NodeType nodeType(Object o) {
            if (o == this) {
                return NodeType.ROOT;
            }
            if (o instanceof AttributePage) {
                return NodeType.PAGE;
            }
            if (o instanceof AttributeGroup) {
                return NodeType.GROUP;
            }
            if (o instanceof AttributeCollection) {
                return NodeType.COLLECTION;
            }
            return NodeType.ATTRIBUTE;
        }

        private String nodeName(Object o, NodeType type) {
            String nodeName = "unknown type";
            switch (type) {
                case ROOT: {
                    return "root";
                }
                case PAGE: {
                    AttributePage page = (AttributePage)this.object;
                    nodeName = page.getDisplayName();
                    if (nodeName == null) {
                        nodeName = page.getDescription();
                    }
                    if (nodeName != null) break;
                    nodeName = "Attribute page without name";
                    break;
                }
                case GROUP: {
                    AttributeGroup group = (AttributeGroup)this.object;
                    nodeName = group.getDisplayName();
                    if (nodeName == null) {
                        nodeName = group.getDescription();
                    }
                    if (nodeName == null) {
                        nodeName = group.getInternalName();
                    }
                    if (nodeName != null) break;
                    nodeName = "Attribute group without name";
                    break;
                }
                case COLLECTION: {
                    AttributeCollection coll = (AttributeCollection)this.object;
                    nodeName = coll.getDisplayName();
                    if (nodeName == null) {
                        nodeName = coll.getDescription();
                    }
                    if (nodeName == null) {
                        nodeName = coll.getInternalName();
                    }
                    if (nodeName != null) break;
                    nodeName = "Attribute collection without name";
                    break;
                }
                case ATTRIBUTE: {
                    AttributeDescription desc = (AttributeDescription)this.object;
                    nodeName = desc.getDisplayName();
                    if (nodeName == null) {
                        nodeName = desc.getDescription();
                    }
                    if (nodeName == null) {
                        nodeName = desc.getInternalName();
                    }
                    if (nodeName != null) break;
                    nodeName = "Attribute group without name";
                }
            }
            return nodeName;
        }

        public String getName() {
            return this.name;
        }

        public NodeType getType() {
            return this.type;
        }

        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return this.name;
        }

        public static enum NodeType {
            ROOT,
            PAGE,
            GROUP,
            COLLECTION,
            ATTRIBUTE;

        }
    }
}

