/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.filter;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterDescription;
import org.gitools.biomart.restful.model.Option;
import org.gitools.ui.biomart.filter.FilterComponent;
import org.gitools.ui.biomart.filter.FilterDescriptionPanel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.utils.FileChooserUtils;

public class FilterTextComponent
extends FilterComponent {
    private String component;
    private final Integer FIELD_HEIGHT = 45;
    private final Integer TEXTAREA_HEIGHT = 130;
    private JButton browse;
    private JPanel browsePanel;
    private JTextField folder;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel nameDescription;
    private JTextArea txtArea;
    private JTextField txtField;

    FilterTextComponent(FilterDescription d, FilterDescriptionPanel parent) {
        super(d, parent);
        this.initComponents();
        this.buildComponent();
    }

    FilterTextComponent(Option o) {
        super(o);
        this.initComponents();
        this.buildComponent();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.txtArea = new JTextArea();
        this.nameDescription = new JLabel();
        this.browsePanel = new JPanel();
        this.folder = new JTextField();
        this.browse = new JButton();
        this.jLabel1.setText("jLabel1");
        this.txtArea.setColumns(20);
        this.txtArea.setRows(5);
        this.jScrollPane1.setViewportView(this.txtArea);
        this.nameDescription.setText("Name");
        this.folder.setEnabled(false);
        this.browse.setLabel("Browse...");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterTextComponent.this.selectFileAction(evt);
            }
        });
        GroupLayout browsePanelLayout = new GroupLayout(this.browsePanel);
        this.browsePanel.setLayout(browsePanelLayout);
        browsePanelLayout.setHorizontalGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, browsePanelLayout.createSequentialGroup().addComponent(this.folder, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browse)));
        browsePanelLayout.setVerticalGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folder, -2, -1, -2).addComponent(this.browse)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browsePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 361, Short.MAX_VALUE).addComponent(this.txtField, -1, 361, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.nameDescription, -1, 69, Short.MAX_VALUE).addGap(292, 292, 292))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.nameDescription).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtField, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browsePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void selectFileAction(ActionEvent evt) {
        File selPath = FileChooserUtils.selectFile("Select file", this.folder.getText(), 2);
        if (selPath != null) {
            this.folder.setText(selPath.getAbsolutePath());
            try {
                this.txtArea.setText(FilterTextComponent.readFileAsString(this.folder.getText()));
            }
            catch (IOException ex) {
                ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                dlg.setVisible(true);
            }
        }
    }

    private void buildComponent() {
        String txt = null;
        if (this.parentPanel != null && this.parentPanel.getRenderLabel().booleanValue()) {
            this.nameDescription.setVisible(true);
        } else {
            this.nameDescription.setVisible(false);
        }
        if (this.filterDescription != null) {
            String string = txt = this.filterDescription.getDefaultValue() != null ? this.filterDescription.getDefaultValue() : "";
            this.component = this.filterDescription.getMultipleValues() == 0 ? "Field" : "TextArea";
        } else if (this.filterOptions != null) {
            String string = txt = this.filterOptions.getDefaultValue() != null ? this.filterOptions.getDefaultValue() : "";
            this.component = this.filterOptions.getMultipleValues() == 0 ? "Field" : "TextArea";
        } else {
            return;
        }
        if (this.component.equals("Field")) {
            this.txtField.setAlignmentY(0.0f);
            this.txtField.setText(txt);
            this.txtField.setVisible(true);
            this.jScrollPane1.setVisible(false);
            this.txtArea.setVisible(false);
            this.browsePanel.setVisible(false);
            this.currentHeight = this.FIELD_HEIGHT;
        } else {
            this.component = "TextArea";
            this.jScrollPane1.setAlignmentY(0.0f);
            this.jScrollPane1.setVisible(true);
            this.txtArea.setAlignmentY(0.0f);
            this.txtArea.setVisible(true);
            this.txtArea.setText("");
            this.browsePanel.setVisible(true);
            this.txtField.setVisible(false);
            this.txtField.setAlignmentY(1.0f);
            this.currentHeight = this.TEXTAREA_HEIGHT;
        }
        if (this.filterDescription != null && this.filterDescription.getDisplayName() != null) {
            this.nameDescription.setText(this.filterDescription.getDisplayName());
        }
    }

    @Override
    public List<Filter> getFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter f = new Filter();
        if (this.filterDescription != null && this.filterDescription.getInternalName() != null) {
            f.setName(this.filterDescription.getInternalName());
        }
        if (this.component.equals("Field")) {
            f.setValue(this.txtField.getText());
        } else {
            f.setValue(this.txtArea.getText().replace("\n", ","));
        }
        f.setValue(f.getValue().replace("\\", "\\\\"));
        f.setValue(f.getValue().replace("\"", "\\\""));
        while (f.getValue().startsWith(",")) {
            f.setValue(f.getValue().substring(1));
        }
        while (f.getValue().endsWith(",")) {
            f.setValue(f.getValue().substring(0, f.getValue().length() - 1));
        }
        filters.add(f);
        return filters;
    }

    @Override
    public Boolean hasChanged() {
        if (this.component.equals("Field")) {
            return this.txtField.getText().equals(this.filterDescription.getDefaultValue() != null ? this.filterDescription.getDefaultValue() : "");
        }
        return this.txtArea.getText().equals(this.filterDescription.getValue());
    }

    private static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(filePath));
        f.read(buffer);
        return new String(buffer);
    }

    @Override
    public void setListOptions(List<Option> optionList) {
    }
}

