/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.filter;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterDescription;
import org.gitools.biomart.restful.model.FilterGroup;
import org.gitools.biomart.restful.model.FilterPage;
import org.gitools.biomart.restful.model.Option;
import org.gitools.biomart.restful.model.PushAction;
import org.gitools.ui.biomart.filter.FilterCollectionPanel;
import org.gitools.ui.biomart.filter.FilterComponent;
import org.gitools.ui.biomart.filter.FilterDescriptionPanel;
import org.gitools.ui.biomart.wizard.BiomartFilterConfigurationPage;

public class FilterSelectComponent
extends FilterComponent {
    private String component;
    private final Integer COMBO_HEIGHT = 45;
    private final Integer LIST_HEIGHT = 190;
    private HashMap<Option, HashMap<String, List<Option>>> pushActions;
    private JComboBox comboComponent;
    private JScrollPane jScrollPane1;
    private JList listComponent;

    public FilterSelectComponent(FilterDescription d, FilterDescriptionPanel collectionParent) {
        super(d, collectionParent);
        this.initComponents();
        this.pushActions = new HashMap();
        this.buildComponent();
        if (this.component.equals("ComboBox") && this.pushActions.size() > 0) {
            this.comboComponent.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        FilterSelectComponent.this.setPushOptionsComponent(((OptionListWrapper)FilterSelectComponent.this.comboComponent.getSelectedItem()).getOption());
                    }
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listComponent = new JList();
        this.comboComponent = new JComboBox();
        this.jScrollPane1.setViewportView(this.listComponent);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 388, Short.MAX_VALUE).addComponent(this.comboComponent, GroupLayout.Alignment.TRAILING, 0, 388, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.comboComponent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 150, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void buildComponent() {
        List<OptionListWrapper> options = this.InitListOptions();
        if (this.filterDescription.getMultipleValues() == 0) {
            this.component = "ComboBox";
            this.comboComponent.setVisible(true);
            this.comboComponent.setAlignmentY(0.0f);
            this.jScrollPane1.setVisible(false);
            this.listComponent.setVisible(false);
            this.listComponent.setAlignmentY(1.0f);
            DefaultComboBoxModel<OptionListWrapper> m = new DefaultComboBoxModel<OptionListWrapper>();
            for (OptionListWrapper o : options) {
                m.addElement(o);
            }
            this.comboComponent.setModel(m);
            this.currentHeight = this.COMBO_HEIGHT;
            if (this.filterDescription != null) {
                this.loadPushActions();
            }
        } else {
            this.component = "List";
            this.listComponent.setVisible(true);
            this.listComponent.setAlignmentY(0.0f);
            DefaultListModel<OptionListWrapper> m = new DefaultListModel<OptionListWrapper>();
            for (OptionListWrapper o : options) {
                m.addElement(o);
            }
            this.listComponent.setModel(m);
            this.comboComponent.setVisible(false);
            this.comboComponent.setAlignmentY(1.0f);
            this.currentHeight = this.LIST_HEIGHT;
        }
        this.validate();
    }

    private void setPushOptionsComponent(Option optionSelected) {
        HashMap<FilterPage, BiomartFilterConfigurationPage.CollectionsPanelsCache> collectionsCache = this.getDescriptionPanel().getParentCollection().getFilterConfigurationPage().getCollectionsCache();
        FilterDescriptionPanel descriptionPanel = null;
        FilterComponent filterCompo = null;
        for (FilterPage page : collectionsCache.keySet()) {
            for (FilterGroup group : collectionsCache.get((Object)page).collections.keySet()) {
                for (FilterCollectionPanel panel : collectionsCache.get((Object)page).collections.get(group)) {
                    for (Component componentPanel : panel.getDescriptionsPanel().getComponents()) {
                        descriptionPanel = (FilterDescriptionPanel)componentPanel;
                        for (Component compo : descriptionPanel.getComponents()) {
                            filterCompo = (FilterComponent)compo;
                            if (filterCompo.getFilterDescription() == null || filterCompo.getFilterDescription().getInternalName() == null || this.pushActions.get(optionSelected).get(filterCompo.getFilterDescription().getInternalName()) == null) continue;
                            filterCompo.setListOptions(this.pushActions.get(optionSelected).get(filterCompo.getFilterDescription().getInternalName()));
                        }
                    }
                }
            }
        }
    }

    private List<OptionListWrapper> InitListOptions() {
        OptionListWrapper wrapper;
        ArrayList<OptionListWrapper> res = new ArrayList<OptionListWrapper>();
        for (Option o : this.filterDescription.getOptions()) {
            wrapper = new OptionListWrapper(o);
            res.add(wrapper);
        }
        if (this.parentPanel != null && this.parentPanel.getParentCollection().getFilterConfigurationPage().getDefaultSelecComposData().size() > 0 && this.parentPanel.getParentCollection().getFilterConfigurationPage().getDefaultSelecComposData().get(this.filterDescription.getInternalName()) != null) {
            for (Option o : this.parentPanel.getParentCollection().getFilterConfigurationPage().getDefaultSelecComposData().get(this.filterDescription.getInternalName())) {
                wrapper = new OptionListWrapper(o);
                res.add(wrapper);
            }
        }
        return res;
    }

    private void loadPushActions() {
        for (Option o : this.filterDescription.getOptions()) {
            if (o.getPushactions() == null) continue;
            HashMap<String, List> actions = new HashMap<String, List>();
            for (PushAction action : o.getPushactions()) {
                actions.put(action.getRef(), action.getOptions());
            }
            this.pushActions.put(o, actions);
        }
    }

    @Override
    public List<Filter> getFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter f = null;
        if (this.hasChild().booleanValue()) {
            if (this.component.equals("ComboBox")) {
                f = new Filter();
                f.setName(((OptionListWrapper)this.comboComponent.getSelectedItem()).getOption().getInternalName());
                f.setValue(this.getChildComponent().getFilters().get(0).getValue());
                f.setRadio(this.getChildComponent().getFilters().get(0).getRadio());
                filters.add(f);
            } else {
                for (Object optionWrapper : this.listComponent.getSelectedValues()) {
                    f = new Filter();
                    f.setName(((OptionListWrapper)optionWrapper).getOption().getInternalName());
                    f.setValue(this.getChildComponent().getFilters().get(0).getValue());
                    f.setRadio(this.getChildComponent().getFilters().get(0).getRadio());
                    filters.add(f);
                }
            }
        } else {
            f = new Filter();
            f.setName(this.filterDescription.getInternalName());
            if (this.component.equals("ComboBox")) {
                if (this.comboComponent.getSelectedItem() != null) {
                    f.setValue(this.comboComponent.getSelectedItem().toString());
                }
            } else if (this.listComponent.getSelectedValues() != null && this.listComponent.getSelectedValues().length > 0) {
                StringBuilder sb = new StringBuilder();
                Object[] list = this.listComponent.getSelectedValues();
                if (list.length > 0) {
                    sb.append(((OptionListWrapper)list[0]).getOption().getValue());
                    for (int i = 1; i < list.length; ++i) {
                        sb.append(", ").append(((OptionListWrapper)list[i]).getOption().getValue());
                    }
                }
                f.setValue(sb.toString());
            }
            filters.add(f);
        }
        return filters;
    }

    @Override
    public Boolean hasChanged() {
        return true;
    }

    @Override
    public void setListOptions(List<Option> optionList) {
        if (this.component.equals("ComboBox")) {
            DefaultComboBoxModel<OptionListWrapper> m = new DefaultComboBoxModel<OptionListWrapper>();
            for (Option o : optionList) {
                m.addElement(new OptionListWrapper(o));
            }
            this.comboComponent.setModel(m);
        } else {
            DefaultListModel<OptionListWrapper> m = new DefaultListModel<OptionListWrapper>();
            for (Option o : optionList) {
                m.addElement(new OptionListWrapper(o));
            }
            this.listComponent.setModel(m);
        }
    }

    public HashMap<Option, HashMap<String, List<Option>>> getPushActions() {
        return this.pushActions;
    }

    public HashMap<String, List<Option>> getPushActionData_defaultOption() {
        if (this.pushActions.size() > 0) {
            if (this.component.equals("ComboBox")) {
                return this.pushActions.get(((OptionListWrapper)this.comboComponent.getSelectedItem()).getOption());
            }
            return this.pushActions.get(((OptionListWrapper)this.listComponent.getSelectedValue()).getOption());
        }
        return new HashMap<String, List<Option>>();
    }

    private static class OptionListWrapper {
        private Option option;

        public OptionListWrapper(Option filterOption) {
            this.option = filterOption;
        }

        public Option getOption() {
            return this.option;
        }

        public String toString() {
            String res = this.option.getDisplayName();
            if (res != null) {
                res = res.replace(":", "");
            }
            return res;
        }
    }
}

