/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.filter;

import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.gitools.biomart.restful.model.DatasetConfig;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterCollection;
import org.gitools.biomart.restful.model.FilterDescription;
import org.gitools.biomart.restful.model.FilterGroup;
import org.gitools.biomart.restful.model.FilterPage;
import org.gitools.biomart.restful.model.Option;
import org.gitools.ui.biomart.filter.FilterCheckBoxComponent;
import org.gitools.ui.biomart.filter.FilterCollectionPanel;
import org.gitools.ui.biomart.filter.FilterComponent;
import org.gitools.ui.biomart.filter.FilterRadioComponent;
import org.gitools.ui.biomart.filter.FilterSelectComponent;
import org.gitools.ui.biomart.filter.FilterTextComponent;

public class FilterDescriptionPanel
extends JPanel {
    private FilterCollectionPanel parentCollection;
    private FilterDescription filterDescription;
    private FilterComponent filterComponent;
    private Integer currentHeight;
    private Boolean renderPanel;
    private Boolean renderLabel;

    public FilterDescriptionPanel(FilterDescription description, FilterCollectionPanel collectionParent, boolean labelRendered) {
        this.filterDescription = description;
        this.parentCollection = collectionParent;
        this.currentHeight = 0;
        this.renderLabel = labelRendered;
        if (this.filterDescription.getDisplayType() != null) {
            this.renderPanel = true;
            this.buildComponent();
        } else if (this.filterDescription.getPointerDataset() != null) {
            try {
                DatasetInfo d = new DatasetInfo();
                d.setName(this.filterDescription.getPointerDataset());
                d.setInterface(this.filterDescription.getPointerInterface());
                DatasetConfig configuration = this.getParentCollection().getFilterConfigurationPage().getBiomartService().getConfiguration(d);
                this.buildPointerFilterComponents(configuration);
                this.renderPanel = true;
            }
            catch (Exception ex) {
                System.out.println("Pointer dataset :" + this.filterDescription.getPointerDataset() + " has not been found");
                this.renderPanel = false;
                return;
            }
        } else {
            this.renderPanel = false;
        }
    }

    private void buildPointerFilterComponents(DatasetConfig configuration) {
        for (FilterPage page : configuration.getFilterPages()) {
            if (page.isHidden() || page.isHideDisplay()) continue;
            for (FilterGroup group : page.getFilterGroups()) {
                if (group.isHidden() || group.isHideDisplay()) continue;
                for (FilterCollection collection : group.getFilterCollections()) {
                    for (FilterDescription desc : collection.getFilterDescriptions()) {
                        if (!desc.getInternalName().equals(this.filterDescription.getPointerFilter()) || desc.isHideDisplay()) continue;
                        this.renderPanel = true;
                        if (this.parentCollection.getFilterConfigurationPage().getDefaultSelecComposData().get(this.filterDescription.getPointerFilter()) != null) {
                            desc.setStyle("menu");
                            desc.setDisplayType("list");
                        }
                        this.filterDescription = desc;
                        this.buildComponent();
                    }
                }
            }
        }
    }

    private void buildComponent() {
        String displayType = this.filterDescription.getDisplayType();
        boolean multipleValues = this.filterDescription.getMultipleValues() == 1;
        String style = this.filterDescription.getStyle();
        String graph = this.filterDescription.getGraph();
        FilterComponent child = null;
        if (displayType.equals("container")) {
            String displayStyleOption = ((Option)this.filterDescription.getOptions().get(0)).getDisplayType();
            int multipleValuesOption = ((Option)this.filterDescription.getOptions().get(0)).getMultipleValues();
            FilterSelectComponent componentParent = new FilterSelectComponent(this.filterDescription, this);
            Option filterOptions = (Option)this.filterDescription.getOptions().get(0);
            if (displayStyleOption.equals("list")) {
                child = multipleValuesOption == 1 ? new FilterCheckBoxComponent(filterOptions) : new FilterRadioComponent(filterOptions);
            } else if (displayStyleOption.equals("text")) {
                child = new FilterTextComponent(filterOptions);
            }
            componentParent.addChildComponent(child);
            this.filterComponent = componentParent;
        } else if (displayType.equals("list")) {
            if (style.equals("menu") && (graph == null || !graph.equals("1"))) {
                FilterSelectComponent selecComponent = new FilterSelectComponent(this.filterDescription, this);
                this.parentCollection.getFilterConfigurationPage().storeSelecComponentsDefaultData(selecComponent.getPushActionData_defaultOption());
                this.filterComponent = selecComponent;
            } else {
                this.filterComponent = style.equals("menu") && graph != null && graph.equals("1") ? new FilterTextComponent(this.filterDescription, this) : (multipleValues ? new FilterCheckBoxComponent(this.filterDescription, this) : new FilterRadioComponent(this.filterDescription, this));
            }
        } else if (displayType.equals("text")) {
            this.filterComponent = new FilterTextComponent(this.filterDescription, this);
        } else {
            System.out.println("Component " + this.filterDescription.getInternalName() + "has not been builded");
            return;
        }
        this.currentHeight = this.filterComponent.getCurrentHeight();
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.filterComponent);
        if (child != null) {
            this.add(child);
            this.currentHeight = this.currentHeight + child.getCurrentHeight();
        }
        this.validate();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 298, Short.MAX_VALUE));
    }

    public FilterDescription getFilterDescription() {
        return this.filterDescription;
    }

    public final FilterCollectionPanel getParentCollection() {
        return this.parentCollection;
    }

    public List<Filter> getFilters() {
        return this.filterComponent.getFilters();
    }

    public void setFilterComponents(FilterComponent components) {
        this.filterComponent = components;
    }

    public Boolean isChild() {
        return this.filterDescription == null;
    }

    Integer getCurrentHeight() {
        return this.currentHeight;
    }

    public Boolean getRenderPanel() {
        return this.renderPanel;
    }

    public void setRenderPanel(Boolean rendered) {
        this.renderPanel = rendered;
    }

    public Boolean getRenderLabel() {
        return this.renderLabel;
    }

    public void setRenderLabel(Boolean renderLabel) {
        this.renderLabel = renderLabel;
    }
}

