/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.filter;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterCollection;
import org.gitools.biomart.restful.model.FilterDescription;
import org.gitools.ui.biomart.filter.FilterDescriptionPanel;
import org.gitools.ui.biomart.wizard.BiomartFilterConfigurationPage;

public class FilterCollectionPanel
extends JPanel {
    private BiomartFilterConfigurationPage filterConfigurationPage;
    private Integer currentHeight = 0;
    private Integer DEFAULT_COLLECTION_PANEL_HEIGHT = 60;
    private Boolean rendered;
    private JCheckBox collectionCheckBox;
    private JPanel descriptionsPanel;

    public FilterCollectionPanel(FilterCollection fc, BiomartFilterConfigurationPage parent) {
        this.initComponents();
        this.rendered = false;
        this.filterConfigurationPage = parent;
        this.buildDescriptions(fc);
    }

    private void buildDescriptions(FilterCollection fc) {
        this.collectionCheckBox.setText(fc.getDisplayName());
        this.descriptionsPanel.removeAll();
        this.descriptionsPanel.setLayout(new BoxLayout(this.descriptionsPanel, 1));
        FilterDescriptionPanel description = null;
        Boolean doLblDescription = this.renderLabelDescription(fc);
        for (FilterDescription d : fc.getFilterDescriptions()) {
            if (d.isHideDisplay()) continue;
            description = new FilterDescriptionPanel(d, this, doLblDescription);
            this.rendered = description.getRenderPanel();
            this.descriptionsPanel.add(description);
            this.currentHeight = this.currentHeight + description.getCurrentHeight();
        }
        this.validate();
    }

    public JPanel getDescriptionsPanel() {
        return this.descriptionsPanel;
    }

    private Boolean renderLabelDescription(FilterCollection fc) {
        Integer components = 0;
        for (FilterDescription d : fc.getFilterDescriptions()) {
            if (d.isHideDisplay()) continue;
            Integer n = components;
            Integer n2 = components = Integer.valueOf(components + 1);
        }
        return components > 1;
    }

    public Boolean isPanelRendered() {
        return this.rendered;
    }

    public FilterCollectionPanel() {
        this.initComponents();
    }

    public Integer getCurrentHeigh() {
        return this.currentHeight + this.DEFAULT_COLLECTION_PANEL_HEIGHT;
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        List<Filter> filtersAux = null;
        if (this.collectionCheckBox.isSelected()) {
            for (Component compo : this.descriptionsPanel.getComponents()) {
                filtersAux = ((FilterDescriptionPanel)compo).getFilters();
                for (Filter f : filtersAux) {
                    if (f.getName() == null || f.getValue() == null || f.getValue().isEmpty()) continue;
                    filters.add(f);
                }
            }
        }
        return filters;
    }

    public BiomartFilterConfigurationPage getFilterConfigurationPage() {
        return this.filterConfigurationPage;
    }

    private void initComponents() {
        this.descriptionsPanel = new JPanel();
        this.collectionCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.descriptionsPanel.setBorder(BorderFactory.createCompoundBorder());
        GroupLayout descriptionsPanelLayout = new GroupLayout(this.descriptionsPanel);
        this.descriptionsPanel.setLayout(descriptionsPanelLayout);
        descriptionsPanelLayout.setHorizontalGroup(descriptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 374, Short.MAX_VALUE));
        descriptionsPanelLayout.setVerticalGroup(descriptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 247, Short.MAX_VALUE));
        this.collectionCheckBox.setText("name");
        this.collectionCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FilterCollectionPanel.this.stateChangedAction(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.collectionCheckBox).addComponent(this.descriptionsPanel, -1, -1, Short.MAX_VALUE)).addGap(16, 16, 16)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.collectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionsPanel, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void stateChangedAction(ChangeEvent evt) {
    }
}

