/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import org.gitools.biomart.restful.model.Filter;
import org.gitools.biomart.restful.model.FilterDescription;
import org.gitools.biomart.restful.model.Option;
import org.gitools.ui.biomart.filter.FilterComponent;
import org.gitools.ui.biomart.filter.FilterDescriptionPanel;

public class FilterCheckBoxComponent
extends FilterComponent {
    private final Integer CHECK_HEIGHT = 45;

    public FilterCheckBoxComponent(FilterDescription d, FilterDescriptionPanel descriptionParent) {
        super(d, descriptionParent);
        this.initComponents();
        this.buildComponent();
    }

    public FilterCheckBoxComponent(Option o) {
        super(o);
        this.initComponents();
        this.buildComponent();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 45, Short.MAX_VALUE));
    }

    private void buildComponent() {
        String[] options = this.getListTextOptions();
        if (options != null) {
            JCheckBox check = null;
            this.setLayout(new GridLayout(options.length, 1));
            for (int i = 0; i < options.length; ++i) {
                check = new JCheckBox(options[i]);
                this.add(check);
            }
            this.currentHeight = this.CHECK_HEIGHT * options.length;
        }
    }

    @Override
    public List<Filter> getFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter f = new Filter();
        if (this.filterDescription != null && this.filterDescription.getInternalName() != null) {
            f.setName(this.filterDescription.getInternalName());
        }
        for (JCheckBox checkBox : (JCheckBox[])this.getComponents()) {
            if (!checkBox.isSelected()) continue;
            f.setValue(checkBox.getText());
        }
        filters.add(f);
        return filters;
    }

    @Override
    public Boolean hasChanged() {
        return true;
    }

    private String[] getListTextOptions() {
        String[] res = null;
        if (this.filterOptions != null) {
            res = new String[this.filterOptions.getOptions().size()];
            for (int i = 0; i < this.filterOptions.getOptions().size(); ++i) {
                res[i] = ((Option)this.filterOptions.getOptions().get(i)).getValue();
            }
        } else {
            if (this.filterDescription == null) {
                return res;
            }
            res = new String[this.filterDescription.getOptions().size()];
            for (int i = 0; i < this.filterDescription.getOptions().size(); ++i) {
                res[i] = ((Option)this.filterDescription.getOptions().get(i)).getValue();
            }
        }
        return res;
    }

    @Override
    public void setListOptions(List<Option> optionList) {
    }
}

