/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.biomart.dialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.ui.biomart.panel.BiomartAttributePanel;

public class BiomartAttributeDialog
extends JDialog {
    boolean cancelled;
    private JButton acceptBtn;
    private BiomartAttributePanel biomartAttrPanel;
    private JButton cancelBtn;
    private JSeparator jSeparator1;

    public BiomartAttributeDialog(Frame parent, List<AttributePage> attrPages) {
        super(parent, true);
        this.initComponents();
        this.setTitle("Select attributes");
        this.updateButtons();
        this.biomartAttrPanel.addAttributeSelectionListener(new BiomartAttributePanel.AttributeSelectionListener(){

            @Override
            public void selectionChanged() {
                BiomartAttributeDialog.this.updateButtons();
            }
        });
        this.cancelled = false;
        this.biomartAttrPanel.setAttributePages(attrPages);
    }

    public void open() {
        this.setVisible(true);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<AttributeDescription> getSelectedAttributes() {
        return this.biomartAttrPanel.getSelectedAttributes();
    }

    public List<String> getSelectedAttributeNames() {
        return this.biomartAttrPanel.getSelectedAttributeNames();
    }

    protected void updateButtons() {
        this.acceptBtn.setEnabled(this.biomartAttrPanel.getSelectedAttributes().size() > 0);
    }

    public void setBiomartParameters(BiomartService port, MartLocation mart, DatasetInfo dataset) {
        this.biomartAttrPanel.setBiomartParameters(port, mart, dataset);
    }

    private void initComponents() {
        this.biomartAttrPanel = new BiomartAttributePanel();
        this.cancelBtn = new JButton();
        this.acceptBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.acceptBtn.setText("Accept");
        this.acceptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiomartAttributeDialog.this.acceptBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(389, Short.MAX_VALUE).addComponent(this.acceptBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelBtn).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSeparator1, -1, 506, Short.MAX_VALUE).addContainerGap()).addComponent(this.biomartAttrPanel, -1, 518, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.biomartAttrPanel, -1, 380, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn).addComponent(this.acceptBtn)).addContainerGap()));
        this.pack();
    }

    private void acceptBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }
}

