/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.batch.tools;

import java.awt.Window;
import java.io.PrintWriter;
import java.io.Writer;
import org.gitools.ui.batch.tools.ITool;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class AbstractTool
implements ITool {
    @Override
    public boolean check(String[] args, PrintWriter out) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            out.print("USAGE | " + this.getName() + "\n");
            parser.printUsage((Writer)out, null);
            return false;
        }
        catch (Exception e) {
            out.println("ERROR " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean run(String[] args, PrintWriter out) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            this.execute();
        }
        catch (CmdLineException e) {
            out.print("USAGE | " + this.getName() + "\n");
            parser.printUsage((Writer)out, null);
            return false;
        }
        catch (Exception e) {
            out.println("ERROR | " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        JobRunnable job = this.newJob();
        if (job != null) {
            AppFrame mainFrame = AppFrame.instance();
            mainFrame.toFront();
            mainFrame.setAlwaysOnTop(true);
            mainFrame.setAlwaysOnTop(false);
            JobThread.execute((Window)mainFrame, (JobRunnable)job);
        }
    }

    protected abstract JobRunnable newJob();
}

