/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.batch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gitools.ui.batch.CommandExecutor;
import org.gitools.ui.platform.AppFrame;

public class CommandListener
implements Runnable {
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    private static final String CRNL = "\r\n";
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONNECTION_CLOSE = "Connection: close";

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    @Override
    public void run() {
        block7: {
            CommandExecutor cmdExe = new CommandExecutor();
            try {
                this.serverSocket = new ServerSocket(this.port);
                log.info((Object)("Listening on port " + this.port));
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error in client socket loop", (Throwable)e);
                    }
                }
            }
            catch (BindException e) {
                log.error((Object)e);
            }
            catch (ClosedByInterruptException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                if (this.halt) break block7;
                log.error((Object)"IO Error on port socket ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                String cmd = inputLine;
                if (cmd.startsWith("GET")) {
                    String command = null;
                    Map<String, String> params = null;
                    String[] tokens = inputLine.split(" ");
                    if (tokens.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    String[] parts = tokens[1].split("\\?");
                    if (parts.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    command = parts[0];
                    params = this.parseParameters(parts[1]);
                    String nextLine = in.readLine();
                    while (nextLine != null && nextLine.length() > 0) {
                        nextLine = in.readLine();
                    }
                    String callback = params.get("callback");
                    if (callback != null) {
                        this.sendHTTPResponse(out, callback);
                    }
                    StringWriter response = new StringWriter();
                    this.processGet(command, params, cmdExe, new PrintWriter(response));
                    if (callback == null) {
                        this.sendHTTPResponse(out, response.toString());
                    }
                    return;
                }
                cmdExe.execute(inputLine.split(" "), out);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error processing client session", (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void sendHTTPResponse(PrintWriter out, String result) {
        out.println(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        if (result != null) {
            out.print("Content-Type: text/html");
            out.print(CRNL);
            out.print(CONTENT_LENGTH + result.length());
            out.print(CRNL);
            out.print(CONNECTION_CLOSE);
            out.print(CRNL);
            out.print(CRNL);
            out.print(result);
            out.print(CRNL);
        }
        out.close();
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e) {
                log.error((Object)"Error closing clientSocket", (Throwable)e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                log.error((Object)"Error closing server socket", (Throwable)e);
            }
        }
    }

    private void processGet(String command, Map<String, String> params, CommandExecutor cmdExe, PrintWriter out) throws IOException {
        AppFrame mainFrame = AppFrame.instance();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/load")) {
            String file = params.get("file");
            if (file != null) {
                cmdExe.execute(new String[]{"load", file}, out);
            } else {
                out.println("ERROR Parameter \"file\" is required");
            }
        } else {
            out.println("ERROR Unknown command: " + command);
        }
        out.flush();
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = CommandListener.decodeURL(kv[0]);
            String value = CommandListener.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }

    public static String decodeURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(s);
        }
    }
}

