/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.gitools.persistence.FileFormat;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;
import org.gitools.ui.utils.FileFormatFilter;

public class SelectFilePage
extends AbstractWizardPage {
    private static final long serialVersionUID = 3840797252370672587L;
    private static final FileFormat anyFileFormat = new FileFormat("Any file format", "", "", false, false);
    private static final FileFormat[] defaultFormats = new FileFormat[]{anyFileFormat};
    private FileFormat[] formats;
    private boolean blankFileAllowed;
    private String lastPath;
    private JButton fileBrowseBtn;
    private JTextField filePath;
    private JComboBox formatCb;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public SelectFilePage(FileFormat[] formats) {
        this.setTitle("Select file");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/SelectFile.png", (int)96));
        this.initComponents();
        this.formats = formats != null ? formats : defaultFormats;
        this.blankFileAllowed = false;
        this.formatCb.setModel(new DefaultComboBoxModel<FileFormat>(formats));
        this.formatCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFilePage.this.updateState();
            }
        });
        DocumentChangeListener docCompleteListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                SelectFilePage.this.updateState();
            }
        };
        this.filePath.getDocument().addDocumentListener(docCompleteListener);
    }

    private void updateState() {
        File rowsFilterFile;
        FileFormat ff = this.getFileFormat();
        this.setMessage(MessageStatus.INFO, "");
        boolean complete = true;
        String path = this.filePath.getText().trim().toLowerCase();
        if (!path.isEmpty() && !ff.checkExtension(path)) {
            this.setMessage(MessageStatus.WARN, "The file extension doesn't match the selected format");
        }
        complete = this.blankFileAllowed || !this.filePath.getText().isEmpty();
        path = this.filePath.getText();
        if (!path.isEmpty() && !(rowsFilterFile = new File(path)).exists()) {
            this.setMessage(MessageStatus.WARN, "File not found: " + path);
        }
        this.setComplete(complete);
    }

    public JComponent createControls() {
        return this;
    }

    public void setBlankFileAllowed(boolean allowed) {
        this.blankFileAllowed = allowed;
        this.updateState();
    }

    protected String getLastPath() {
        if (this.lastPath == null) {
            this.lastPath = new File(".").getAbsolutePath();
        }
        return this.lastPath;
    }

    protected void setLastPath(String path) {
        this.lastPath = path;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.formatCb = new JComboBox();
        this.jLabel2 = new JLabel();
        this.filePath = new JTextField();
        this.fileBrowseBtn = new JButton();
        this.jLabel1.setText("Format");
        this.formatCb.setModel(new DefaultComboBoxModel<String>(new String[]{"Binary data matrix", "Continuous data matrix"}));
        this.jLabel2.setText("File");
        this.fileBrowseBtn.setText("Browse...");
        this.fileBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectFilePage.this.fileBrowseBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatCb, 0, 570, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePath, -1, 519, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileBrowseBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatCb, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileBrowseBtn).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filePath, -2, -1, -2).addComponent(this.jLabel2))).addContainerGap(283, Short.MAX_VALUE)));
    }

    private void fileBrowseBtnActionPerformed(ActionEvent evt) {
        boolean anyFormat = this.formats.length == 1 && this.formats[0] == anyFileFormat;
        FileFilter any = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }

            @Override
            public String getDescription() {
                return anyFileFormat.getTitle();
            }
        };
        FileFilter[] filters = null;
        if (anyFormat) {
            filters = new FileFilter[]{any};
        } else {
            filters = new FileFilter[this.formats.length + 2];
            filters[0] = any;
            filters[1] = new FileFormatFilter("Known formats", null, this.formats);
            for (int i = 0; i < this.formats.length; ++i) {
                filters[i + 2] = new FileFormatFilter(this.formats[i]);
            }
        }
        FileChooserUtils.FileAndFilter sel = FileChooserUtils.selectFile("Select file", this.getLastPath(), 2, filters);
        if (sel != null) {
            File selPath = sel.getFile();
            this.setFile(selPath);
            this.setLastPath(selPath.getAbsolutePath());
        }
    }

    public FileFormat getFileFormat() {
        return (FileFormat)this.formatCb.getSelectedItem();
    }

    public File getFile() {
        String path = this.filePath.getText();
        return path.isEmpty() ? null : new File(path);
    }

    public void setFile(File file) {
        String fileName = file.getName();
        for (FileFormat f : this.formats) {
            if (!f.checkExtension(fileName)) continue;
            this.formatCb.setSelectedItem(f);
            break;
        }
        this.filePath.setText(file.getAbsolutePath());
        this.updateState();
    }
}

