/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;

public class ModulesPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -3938595143114651781L;
    private static final FileFormat[] formats = new FileFormat[]{FileFormats.MODULES_2C_MAP, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.MODULES_INDEXED_MAP};
    private boolean emptyFileAllowed;
    private JButton fileBrowseBtn;
    private JComboBox fileFormatCb;
    private JTextField filePath;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    public JCheckBox maxSizeEnableChk;
    public JComboBox maxSizeValueCb;
    public JCheckBox minSizeEnableChk;
    public JComboBox minSizeValueCb;

    public ModulesPage() {
        this.setTitle("Select modules");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Modules.png", (int)96));
        this.initComponents();
        this.emptyFileAllowed = false;
        this.fileFormatCb.setModel(new DefaultComboBoxModel<FileFormat>(formats));
        this.fileFormatCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModulesPage.this.updateState();
            }
        });
        this.filePath.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                ModulesPage.this.updateState();
            }
        });
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModulesPage.this.updateState();
            }
        };
        this.minSizeEnableChk.addItemListener(il);
        this.maxSizeEnableChk.addItemListener(il);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModulesPage.this.updateState();
            }
        };
        this.minSizeValueCb.addActionListener(al);
        this.maxSizeValueCb.addActionListener(al);
    }

    public JComponent createControls() {
        return this;
    }

    private void updateState() {
        this.minSizeValueCb.setEnabled(this.minSizeEnableChk.isSelected());
        this.maxSizeValueCb.setEnabled(this.maxSizeEnableChk.isSelected());
        boolean completed = this.emptyFileAllowed || !this.filePath.getText().isEmpty();
        this.setMessage(MessageStatus.INFO, "");
        try {
            Integer.parseInt((String)this.maxSizeValueCb.getSelectedItem());
        }
        catch (NumberFormatException ex) {
            this.setStatus(MessageStatus.ERROR);
            this.setMessage("Invalid number for modules having more annotated rows filter");
            completed = false;
        }
        try {
            Integer.parseInt((String)this.minSizeValueCb.getSelectedItem());
        }
        catch (NumberFormatException ex) {
            this.setStatus(MessageStatus.ERROR);
            this.setMessage("Invalid number for modules having less annotated rows filter");
            completed = false;
        }
        String path = this.filePath.getText().trim().toLowerCase();
        if (!path.isEmpty() && !this.getFileFormat().checkExtension(path)) {
            this.setMessage(MessageStatus.WARN, "The file extension doesn't match the selected format");
        }
        this.setComplete(completed);
    }

    private void initComponents() {
        this.minSizeEnableChk = new JCheckBox();
        this.minSizeValueCb = new JComboBox();
        this.jLabel1 = new JLabel();
        this.fileFormatCb = new JComboBox();
        this.jLabel2 = new JLabel();
        this.filePath = new JTextField();
        this.fileBrowseBtn = new JButton();
        this.maxSizeEnableChk = new JCheckBox();
        this.maxSizeValueCb = new JComboBox();
        this.jLabel3 = new JLabel();
        this.minSizeEnableChk.setSelected(true);
        this.minSizeEnableChk.setText("Omit modules having less annotated rows than");
        this.minSizeEnableChk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ModulesPage.this.minSizeEnableChkItemStateChanged(evt);
            }
        });
        this.minSizeValueCb.setEditable(true);
        this.minSizeValueCb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "20", "30", "50", "100"}));
        this.minSizeValueCb.setSelectedIndex(2);
        this.jLabel1.setText("File format");
        this.fileFormatCb.setModel(new DefaultComboBoxModel<String>(new String[]{"Two columns mappings", "Binary data matrix"}));
        this.jLabel2.setText("File");
        this.fileBrowseBtn.setText("Browse...");
        this.fileBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPage.this.fileBrowseBtnActionPerformed(evt);
            }
        });
        this.maxSizeEnableChk.setText("Omit modules having more annotated rows than");
        this.maxSizeValueCb.setEditable(true);
        this.maxSizeValueCb.setModel(new DefaultComboBoxModel<String>(new String[]{"20", "30", "50", "100"}));
        this.maxSizeValueCb.setEnabled(false);
        this.jLabel3.setText("Filtering options:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileFormatCb, 0, 455, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePath, -1, 426, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileBrowseBtn))).addGap(26, 26, 26)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap(456, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minSizeEnableChk, -1, -1, Short.MAX_VALUE).addComponent(this.maxSizeEnableChk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.minSizeValueCb, 0, 209, Short.MAX_VALUE).addComponent(this.maxSizeValueCb, 0, 209, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileFormatCb, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.fileBrowseBtn).addComponent(this.filePath, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minSizeEnableChk).addComponent(this.minSizeValueCb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxSizeValueCb, -2, -1, -2).addComponent(this.maxSizeEnableChk)).addContainerGap(125, Short.MAX_VALUE)));
    }

    private void minSizeEnableChkItemStateChanged(ItemEvent evt) {
        this.minSizeValueCb.setEnabled(this.minSizeEnableChk.isSelected());
    }

    private void fileBrowseBtnActionPerformed(ActionEvent evt) {
        File selPath = FileChooserUtils.selectFile("Select file", Settings.getDefault().getLastMapPath(), 2);
        if (selPath != null) {
            this.setSelectedFile(selPath);
            Settings.getDefault().setLastMapPath(selPath.getParentFile().getAbsolutePath());
        }
    }

    protected FileFormat getFileFormat() {
        return (FileFormat)this.fileFormatCb.getSelectedItem();
    }

    public String getFileMime() {
        return ((FileFormat)this.fileFormatCb.getSelectedItem()).getMime();
    }

    public File getSelectedFile() {
        String path = this.filePath.getText();
        return path.isEmpty() ? null : new File(path);
    }

    public void setSelectedFile(File file) {
        String fileName = file.getName();
        for (FileFormat ff : formats) {
            if (!ff.checkExtension(fileName)) continue;
            this.fileFormatCb.setSelectedItem(ff);
            break;
        }
        this.filePath.setText(file.getAbsolutePath());
    }

    public int getMinSize() {
        int value = Integer.parseInt((String)this.minSizeValueCb.getSelectedItem());
        return this.minSizeEnableChk.isSelected() ? value : 0;
    }

    public void setMinSize(int size) {
        this.minSizeValueCb.setSelectedItem(String.valueOf(size));
        this.minSizeEnableChk.setSelected(size != 0);
    }

    public int getMaxSize() {
        int value = Integer.parseInt((String)this.maxSizeValueCb.getSelectedItem());
        return this.maxSizeEnableChk.isSelected() ? value : Integer.MAX_VALUE;
    }

    public void setMaxSize(int size) {
        this.maxSizeValueCb.setSelectedItem(String.valueOf(size));
        this.maxSizeEnableChk.setSelected(size != 0 && size != Integer.MAX_VALUE);
    }

    public void setEmptyFileAllowed(boolean allowed) {
        this.emptyFileAllowed = allowed;
        this.updateState();
    }
}

