/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.wizard;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;

public class DataFilterPage
extends AbstractWizardPage {
    private static final long serialVersionUID = 3840797252370672587L;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox cutoffCmpCb;
    private JCheckBox cutoffEnabledCheck;
    private JTextField cutoffValue;
    private JCheckBox discardNonMappedRowsCheck;
    private JCheckBox populationCheck;
    private JComboBox populationDefaultValueCb;
    private JLabel populationDefaultValueLabel;
    private JButton populationFileBrowserBtn;
    private JTextField populationFilePath;
    private JLabel populationNote;

    public DataFilterPage() {
        this.setTitle("Select data filtering options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Data.png", (int)96));
        this.initComponents();
        DocumentChangeListener docCompleteListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                DataFilterPage.this.updateState();
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataFilterPage.this.updateState();
            }
        };
        this.populationCheck.addItemListener(itemListener);
        this.populationFilePath.getDocument().addDocumentListener(docCompleteListener);
        this.cutoffEnabledCheck.addItemListener(itemListener);
        String[] cmpNames = new String[CutoffCmp.comparators.length];
        for (int i = 0; i < cmpNames.length; ++i) {
            cmpNames[i] = CutoffCmp.comparators[i].getLongName();
        }
        this.cutoffCmpCb.setModel(new DefaultComboBoxModel<String>(cmpNames));
        this.cutoffCmpCb.setSelectedItem(CutoffCmp.GE.getLongName());
        this.cutoffValue.getDocument().addDocumentListener(docCompleteListener);
        this.cutoffValue.setText("1.5");
        this.discardNonMappedRowsCheck.addItemListener(itemListener);
        this.discardNonMappedRowsCheck.setVisible(false);
    }

    private void updateState() {
        File rowsFilterFile;
        String rowsFilterPath;
        boolean binaryFilterEnabled = true;
        this.cutoffEnabledCheck.setEnabled(binaryFilterEnabled);
        this.cutoffCmpCb.setEnabled(binaryFilterEnabled && this.cutoffEnabledCheck.isSelected());
        this.cutoffValue.setEnabled(binaryFilterEnabled && this.cutoffEnabledCheck.isSelected());
        this.setMessage(MessageStatus.INFO, "");
        boolean complete = true;
        if (this.cutoffEnabledCheck.isSelected()) {
            boolean fail = false;
            try {
                Double.valueOf(this.cutoffValue.getText());
            }
            catch (NumberFormatException e) {
                fail = true;
                this.setStatus(MessageStatus.ERROR);
                this.setMessage("Cutoff value should be a real number.");
            }
            boolean bl = complete = !fail && !this.cutoffValue.getText().isEmpty();
        }
        if (!(rowsFilterPath = this.populationFilePath.getText()).isEmpty() && !(rowsFilterFile = new File(rowsFilterPath)).exists()) {
            complete = false;
            this.setMessage(MessageStatus.ERROR, "File not found: " + rowsFilterPath);
        }
        boolean populationChecked = this.populationCheck.isSelected();
        this.populationFilePath.setEnabled(populationChecked);
        this.populationFileBrowserBtn.setEnabled(populationChecked);
        this.populationNote.setEnabled(populationChecked);
        this.populationDefaultValueLabel.setEnabled(populationChecked);
        this.populationDefaultValueCb.setEnabled(populationChecked);
        if (populationChecked && this.populationFilePath.getDocument().getLength() == 0) {
            complete = false;
            this.setMessage(MessageStatus.ERROR, "Select a file containing rows");
        }
        this.setComplete(complete);
    }

    public JComponent createControls() {
        return this;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.cutoffEnabledCheck = new JCheckBox();
        this.cutoffCmpCb = new JComboBox();
        this.cutoffValue = new JTextField();
        this.populationFilePath = new JTextField();
        this.populationFileBrowserBtn = new JButton();
        this.discardNonMappedRowsCheck = new JCheckBox();
        this.populationCheck = new JCheckBox();
        this.populationNote = new JLabel();
        this.populationDefaultValueLabel = new JLabel();
        this.populationDefaultValueCb = new JComboBox();
        this.cutoffEnabledCheck.setText("Transform to 1 (0 otherwise) cells with value");
        this.cutoffEnabledCheck.setEnabled(false);
        this.cutoffCmpCb.setEnabled(false);
        this.cutoffValue.setColumns(6);
        this.cutoffValue.setEnabled(false);
        this.populationFileBrowserBtn.setText("Browse...");
        this.populationFileBrowserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFilterPage.this.populationFileBrowserBtnActionPerformed(evt);
            }
        });
        this.discardNonMappedRowsCheck.setText("Filter out rows for which no information appears in the modules");
        this.populationCheck.setText("Population / Background elements:");
        this.populationNote.setFont(this.populationNote.getFont().deriveFont((float)this.populationNote.getFont().getSize() - 2.0f));
        this.populationNote.setText("This should be a file containing one row id per line.");
        this.populationDefaultValueLabel.setText("Default value to use when a row doesn't exist in the data");
        this.populationDefaultValueCb.setEditable(true);
        this.populationDefaultValueCb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "Empty"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.populationCheck).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.populationNote).addGroup(layout.createSequentialGroup().addComponent(this.populationFilePath, -1, 540, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.populationFileBrowserBtn)).addGroup(layout.createSequentialGroup().addComponent(this.populationDefaultValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.populationDefaultValueCb, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.cutoffEnabledCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffCmpCb, 0, 224, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffValue, -2, -1, -2)).addComponent(this.discardNonMappedRowsCheck)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.populationCheck).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.populationFilePath, -2, -1, -2).addComponent(this.populationFileBrowserBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.populationNote).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.populationDefaultValueLabel).addComponent(this.populationDefaultValueCb, -2, -1, -2)).addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutoffEnabledCheck).addComponent(this.cutoffCmpCb, -2, -1, -2).addComponent(this.cutoffValue, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.discardNonMappedRowsCheck).addContainerGap(141, Short.MAX_VALUE)));
    }

    private void populationFileBrowserBtnActionPerformed(ActionEvent evt) {
        File selPath = FileChooserUtils.selectFile("Select file", Settings.getDefault().getLastDataPath(), 2);
        if (selPath != null) {
            this.populationFilePath.setText(selPath.getAbsolutePath());
            Settings.getDefault().setLastDataPath(selPath.getAbsolutePath());
        }
    }

    public void setRowsFilterFileVisible(boolean visible) {
        this.populationCheck.setVisible(visible);
        this.populationFilePath.setVisible(visible);
        this.populationFileBrowserBtn.setVisible(visible);
        this.populationNote.setVisible(visible);
    }

    public File getRowsFilterFile() {
        String text = this.populationFilePath.getText();
        return this.populationCheck.isSelected() && !text.isEmpty() ? new File(text) : null;
    }

    public boolean isBinaryCutoffEnabled() {
        return this.cutoffEnabledCheck.isSelected();
    }

    public void setBinaryCutoffEnabled(boolean enabled) {
        this.cutoffEnabledCheck.setSelected(enabled);
    }

    public CutoffCmp getBinaryCutoffCmp() {
        return CutoffCmp.getFromName((String)this.cutoffCmpCb.getSelectedItem());
    }

    public void setBinaryCutoffCmp(CutoffCmp cmp) {
        this.cutoffCmpCb.setSelectedItem(cmp.getLongName());
    }

    public double getBinaryCutoffValue() {
        return Double.parseDouble(this.cutoffValue.getText());
    }

    public void setBinaryCutoffValue(double value) {
        this.cutoffValue.setText(Double.toString(value));
    }

    public boolean isDiscardNonMappedRowsEnabled() {
        return this.discardNonMappedRowsCheck.isSelected();
    }

    public void setDiscardNonMappedRowsEnabled(boolean enabled) {
        this.discardNonMappedRowsCheck.setSelected(enabled);
    }

    public boolean isDiscardNonMappedRowsVisible() {
        return this.discardNonMappedRowsCheck.isVisible();
    }

    public void setDiscardNonMappedRowsVisible(boolean visible) {
        this.discardNonMappedRowsCheck.setVisible(visible);
    }

    public Double getPopulationDefaultValue() {
        String value = (String)this.populationDefaultValueCb.getSelectedItem();
        Double v = Double.NaN;
        try {
            v = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }
}

