/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.gitools.model.Attribute;
import org.gitools.ui.analysis.wizard.AttributeDialog;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class AnalysisDetailsPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -6310021084299136899L;
    private AttributesModel attrModel;
    private JButton attrAddBtn;
    private JButton attrEditBtn;
    private JButton attrRemoveBtn;
    private JTable attrTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea notesArea;
    private JTextField titleField;

    public AnalysisDetailsPage() {
        this.setTitle("Analysis details");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/AnalysisDetails.png", (int)96));
        this.setComplete(true);
        this.initComponents();
        this.attrModel = new AttributesModel();
        this.attrTable.setModel(this.attrModel);
        this.attrTable.setSelectionMode(0);
        this.attrTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = AnalysisDetailsPage.this.attrTable.getSelectedRow();
                AnalysisDetailsPage.this.attrEditBtn.setEnabled(row != -1);
                AnalysisDetailsPage.this.attrRemoveBtn.setEnabled(row != -1);
            }
        });
    }

    public JComponent createControls() {
        return this;
    }

    public String getAnalysisTitle() {
        return this.titleField.getText();
    }

    public void setAnalysisTitle(String title) {
        this.titleField.setText(title);
    }

    public String getAnalysisNotes() {
        return this.notesArea.getText();
    }

    public void setAnalysisNotes(String notes) {
        this.notesArea.setText(notes);
    }

    public List<Attribute> getAnalysisAttributes() {
        return this.attrModel.getAttributes();
    }

    public void setAnalysisAttributes(List<Attribute> attrs) {
        this.attrModel = new AttributesModel(attrs);
        this.attrTable.setModel(this.attrModel);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.titleField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.notesArea = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.attrTable = new JTable();
        this.attrAddBtn = new JButton();
        this.attrRemoveBtn = new JButton();
        this.attrEditBtn = new JButton();
        this.jLabel1.setText("Title");
        this.jLabel2.setText("Notes");
        this.notesArea.setColumns(20);
        this.notesArea.setLineWrap(true);
        this.notesArea.setRows(3);
        this.notesArea.setTabSize(4);
        this.jScrollPane1.setViewportView(this.notesArea);
        this.jLabel3.setText("Attributes");
        this.jScrollPane2.setEnabled(false);
        this.attrTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.attrTable);
        this.attrAddBtn.setText("Add");
        this.attrAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisDetailsPage.this.attrAddBtnActionPerformed(evt);
            }
        });
        this.attrRemoveBtn.setText("Remove");
        this.attrRemoveBtn.setEnabled(false);
        this.attrRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisDetailsPage.this.attrRemoveBtnActionPerformed(evt);
            }
        });
        this.attrEditBtn.setText("Edit");
        this.attrEditBtn.setEnabled(false);
        this.attrEditBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisDetailsPage.this.attrEditBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 559, Short.MAX_VALUE).addComponent(this.titleField, -1, 559, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 559, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 559, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 451, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.attrRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.attrEditBtn, -1, -1, Short.MAX_VALUE).addComponent(this.attrAddBtn, -1, 96, Short.MAX_VALUE))).addComponent(this.jLabel3, -1, 559, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 85, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.attrAddBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attrEditBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attrRemoveBtn)).addComponent(this.jScrollPane2, 0, 0, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void attrAddBtnActionPerformed(ActionEvent evt) {
        AttributeDialog dlg = new AttributeDialog(null);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.attrModel.addAttribute(dlg.getAttribute());
    }

    private void attrEditBtnActionPerformed(ActionEvent evt) {
        int row = this.attrTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        AttributeDialog dlg = new AttributeDialog(null);
        dlg.setAttribute(this.attrModel.getAttribute(row));
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.attrModel.modifyAttribute(row, dlg.getAttribute());
    }

    private void attrRemoveBtnActionPerformed(ActionEvent evt) {
        int row = this.attrTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        this.attrModel.removeAttribute(row);
    }

    private static class AttributesModel
    implements TableModel {
        private List<Attribute> attrs;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        public AttributesModel() {
            this.attrs = new ArrayList<Attribute>();
        }

        public AttributesModel(List<Attribute> attrs) {
            this.attrs = attrs != null ? attrs : new ArrayList();
        }

        @Override
        public int getRowCount() {
            return this.attrs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Name" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Attribute attr = this.attrs.get(rowIndex);
            return columnIndex == 0 ? attr.getName() : attr.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public List<Attribute> getAttributes() {
            return this.attrs;
        }

        public Attribute getAttribute(int index) {
            return this.attrs.get(index);
        }

        public void addAttribute(Attribute attr) {
            this.attrs.add(attr);
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        private void modifyAttribute(int index, Attribute attribute) {
            Attribute attr = this.getAttribute(index);
            attr.setName(attribute.getName());
            attr.setValue(attribute.getValue());
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        public void removeAttribute(int index) {
            this.attrs.remove(index);
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }
    }
}

