/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.overlapping.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class OverlappingAnalysisWizardPage
extends AbstractWizardPage {
    private List<IElementAttribute> attrs;
    private ButtonGroup applyGroup;
    private JRadioButton applyToColumnsRb;
    private JRadioButton applyToRowsRb;
    private JComboBox attributeCb;
    private JLabel attributeLabel;
    private JLabel jLabel2;
    private JCheckBox replaceEmptyValuesCheck;
    private JTextField replaceValueField;

    public OverlappingAnalysisWizardPage() {
        this.initComponents();
        this.setTitle("Configure overlapping options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setComplete(true);
        this.replaceEmptyValuesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlappingAnalysisWizardPage.this.replaceValueField.setEnabled(OverlappingAnalysisWizardPage.this.replaceEmptyValuesCheck.isSelected());
            }
        });
        this.replaceValueField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                boolean valid = OverlappingAnalysisWizardPage.this.isValidNumber(OverlappingAnalysisWizardPage.this.replaceValueField.getText());
                boolean completed = !OverlappingAnalysisWizardPage.this.replaceEmptyValuesCheck.isSelected() || valid;
                OverlappingAnalysisWizardPage.this.setComplete(completed);
                if (!valid) {
                    OverlappingAnalysisWizardPage.this.setStatus(MessageStatus.ERROR);
                    OverlappingAnalysisWizardPage.this.setMessage("Invalid replacement for empty values, it should be a real number");
                } else {
                    OverlappingAnalysisWizardPage.this.setMessage(MessageStatus.INFO, "");
                }
            }
        });
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.attributeLabel = new JLabel();
        this.attributeCb = new JComboBox();
        this.replaceEmptyValuesCheck = new JCheckBox();
        this.replaceValueField = new JTextField();
        this.jLabel2 = new JLabel();
        this.applyToColumnsRb = new JRadioButton();
        this.applyToRowsRb = new JRadioButton();
        this.attributeLabel.setText("Take values from");
        this.replaceEmptyValuesCheck.setText("Replace empty values by");
        this.replaceEmptyValuesCheck.setVerticalAlignment(1);
        this.replaceValueField.setText("0");
        this.replaceValueField.setEnabled(false);
        this.jLabel2.setText("Apply to:");
        this.applyGroup.add(this.applyToColumnsRb);
        this.applyToColumnsRb.setSelected(true);
        this.applyToColumnsRb.setText("Columns");
        this.applyGroup.add(this.applyToRowsRb);
        this.applyToRowsRb.setText("Rows");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.attributeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributeCb, -2, 301, -2)).addGroup(layout.createSequentialGroup().addComponent(this.replaceEmptyValuesCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceValueField, -2, 181, -2)).addComponent(this.jLabel2).addComponent(this.applyToColumnsRb).addComponent(this.applyToRowsRb)).addContainerGap(100, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeLabel).addComponent(this.attributeCb, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceEmptyValuesCheck).addComponent(this.replaceValueField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyToColumnsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToRowsRb).addContainerGap(116, Short.MAX_VALUE)));
    }

    public JComponent createControls() {
        return this;
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public void setAttributes(List<IElementAttribute> attrs) {
        this.attrs = attrs;
        if (attrs != null) {
            AttrOption[] pvalueAttrs = new AttrOption[attrs.size()];
            for (int i = 0; i < attrs.size(); ++i) {
                pvalueAttrs[i] = new AttrOption(attrs.get(i));
            }
            this.attributeCb.setModel(new DefaultComboBoxModel<AttrOption>(pvalueAttrs));
            this.attributeCb.setSelectedIndex(0);
            this.attributeCb.setEnabled(true);
            this.attributeCb.setVisible(true);
            this.attributeLabel.setVisible(true);
        } else {
            this.dissableAttrCb();
        }
    }

    private void dissableAttrCb() {
        this.attributeCb.setModel(new DefaultComboBoxModel());
        this.attributeCb.setEnabled(false);
        this.attributeCb.setVisible(false);
        this.attributeLabel.setVisible(false);
    }

    public int getAttributeIndex() {
        return this.attributeCb.getSelectedIndex();
    }

    public boolean isReplaceNanValuesEnabled() {
        return this.replaceEmptyValuesCheck.isSelected();
    }

    public double getReplaceNanValue() {
        return Double.parseDouble(this.replaceValueField.getText());
    }

    public boolean isTransposeEnabled() {
        return this.applyToRowsRb.isSelected();
    }

    public void setReplaceNanValue(double value) {
        this.replaceValueField.setText(Double.toString(value));
    }

    public void setTransposeEnabled(boolean enabled) {
        this.applyToRowsRb.setSelected(enabled);
    }

    public void setReplaceNanValuesEnabled(boolean enabled) {
        this.replaceEmptyValuesCheck.setSelected(enabled);
    }

    private static class AttrOption {
        private String name;
        private IElementAttribute attr;

        public AttrOption(String name) {
            this.name = name;
        }

        public AttrOption(IElementAttribute attr) {
            this.attr = attr;
        }

        public IElementAttribute getAttr() {
            return this.attr;
        }

        public String toString() {
            return this.attr != null ? this.attr.getName() : this.name;
        }
    }
}

