/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.overlapping.wizard;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.overlapping.wizard.OverlappingAnalysisWizardPage;
import org.gitools.ui.analysis.wizard.AnalysisDetailsPage;
import org.gitools.ui.analysis.wizard.DataFilePage;
import org.gitools.ui.analysis.wizard.DataFilterPage;
import org.gitools.ui.analysis.wizard.ExamplePage;
import org.gitools.ui.examples.ExamplesManager;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class OverlappingAnalysisWizard
extends AbstractWizard {
    private static final String EXAMPLE_ANALYSIS_FILE = "analysis.overlapping";
    private static final String EXAMPLE_DATA_FILE = "8_kidney_6_brain_downreg_annot.cdm.gz";
    private static final FileFormat[] dataFormats = new FileFormat[]{FileFormats.RESULTS_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.MODULES_2C_MAP, FileFormats.MODULES_INDEXED_MAP};
    private ExamplePage examplePage;
    private DataFilePage dataPage;
    private DataFilterPage dataFilterPage;
    private OverlappingAnalysisWizardPage overlappingPage;
    private SaveFilePage saveFilePage;
    private AnalysisDetailsPage analysisDetailsPage;
    private boolean examplePageEnabled = true;
    private boolean dataFromMemory = false;
    private List<IElementAttribute> attributes;
    private boolean saveFilePageEnabled = true;

    public OverlappingAnalysisWizard() {
        this.setTitle("Overlapping analysis");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Overlapping.png", (int)96));
        this.setHelpContext("analysis_overlapping");
    }

    public void addPages() {
        if (this.examplePageEnabled && Settings.getDefault().isShowCombinationExamplePage()) {
            this.examplePage = new ExamplePage("an overlapping analysis");
            this.examplePage.setTitle("Overlapping analysis");
            this.addPage((IWizardPage)this.examplePage);
        }
        if (!this.dataFromMemory) {
            this.dataPage = new DataFilePage(dataFormats);
            this.addPage((IWizardPage)this.dataPage);
        }
        this.dataFilterPage = new DataFilterPage();
        this.dataFilterPage.setRowsFilterFileVisible(false);
        this.dataFilterPage.setBinaryCutoffCmp(CutoffCmp.LT);
        this.dataFilterPage.setBinaryCutoffValue(0.05);
        this.dataFilterPage.setBinaryCutoffEnabled(true);
        this.addPage((IWizardPage)this.dataFilterPage);
        this.overlappingPage = new OverlappingAnalysisWizardPage();
        this.overlappingPage.setAttributes(this.attributes);
        this.addPage((IWizardPage)this.overlappingPage);
        if (this.saveFilePageEnabled) {
            this.saveFilePage = new SaveFilePage();
            this.saveFilePage.setTitle("Select destination file");
            this.saveFilePage.setFolder(Settings.getDefault().getLastWorkPath());
            this.saveFilePage.setFormats(new FileFormat[]{FileFormats.OVERLAPPING});
            this.saveFilePage.setFormatsVisible(false);
            this.addPage((IWizardPage)this.saveFilePage);
        }
        this.analysisDetailsPage = new AnalysisDetailsPage();
        this.addPage((IWizardPage)this.analysisDetailsPage);
    }

    public void pageLeft(IWizardPage currentPage) {
        if (currentPage == this.examplePage) {
            Settings.getDefault().setShowCombinationExamplePage(this.examplePage.isShowAgain());
            if (this.examplePage.isExampleEnabled()) {
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        final File basePath = ExamplesManager.getDefault().resolvePath("overlap", monitor);
                        if (basePath == null) {
                            throw new RuntimeException("Unexpected error: There are no examples available");
                        }
                        File analysisFile = new File(basePath, OverlappingAnalysisWizard.EXAMPLE_ANALYSIS_FILE);
                        Properties props = new Properties();
                        props.setProperty("load_references", "false");
                        try {
                            monitor.begin("Loading example parameters ...", 1);
                            final OverlappingAnalysis a = (OverlappingAnalysis)PersistenceManager.getDefault().load(analysisFile, props, monitor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    OverlappingAnalysisWizard.this.setAnalysis(a);
                                    OverlappingAnalysisWizard.this.dataPage.setFile(new File(basePath, OverlappingAnalysisWizard.EXAMPLE_DATA_FILE));
                                    OverlappingAnalysisWizard.this.saveFilePage.setFileNameWithoutExtension("example");
                                }
                            });
                            monitor.end();
                        }
                        catch (Exception ex) {
                            monitor.exception(ex);
                        }
                    }
                });
            }
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getCurrentPage();
        boolean canFinish = super.canFinish();
        return canFinish |= page == this.saveFilePage && page.isComplete();
    }

    public boolean isExamplePageEnabled() {
        return this.examplePageEnabled;
    }

    public void setExamplePageEnabled(boolean examplePageEnabled) {
        this.examplePageEnabled = examplePageEnabled;
    }

    public boolean isDataFromMemory() {
        return this.dataFromMemory;
    }

    public void setDataFromMemory(boolean dataFromMemory) {
        this.dataFromMemory = dataFromMemory;
    }

    public List<IElementAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<IElementAttribute> attributes) {
        this.attributes = attributes;
    }

    public boolean isSaveFilePageEnabled() {
        return this.saveFilePageEnabled;
    }

    public void setSaveFilePageEnabled(boolean saveFilePageEnabled) {
        this.saveFilePageEnabled = saveFilePageEnabled;
    }

    public OverlappingAnalysis getAnalysis() {
        OverlappingAnalysis a = new OverlappingAnalysis();
        a.setTitle(this.analysisDetailsPage.getAnalysisTitle());
        a.setDescription(this.analysisDetailsPage.getAnalysisNotes());
        a.setAttributes(this.analysisDetailsPage.getAnalysisAttributes());
        a.setBinaryCutoffEnabled(this.dataFilterPage.isBinaryCutoffEnabled());
        a.setBinaryCutoffCmp(this.dataFilterPage.getBinaryCutoffCmp());
        a.setBinaryCutoffValue(Double.valueOf(this.dataFilterPage.getBinaryCutoffValue()));
        a.setReplaceNanValue(this.overlappingPage.isReplaceNanValuesEnabled() ? Double.valueOf(this.overlappingPage.getReplaceNanValue()) : null);
        a.setTransposeData(this.overlappingPage.isTransposeEnabled());
        return a;
    }

    private void setAnalysis(OverlappingAnalysis a) {
        this.analysisDetailsPage.setAnalysisTitle(a.getTitle());
        this.analysisDetailsPage.setAnalysisNotes(a.getDescription());
        this.analysisDetailsPage.setAnalysisAttributes(a.getAttributes());
        this.dataFilterPage.setBinaryCutoffEnabled(a.isBinaryCutoffEnabled());
        this.dataFilterPage.setBinaryCutoffCmp(a.getBinaryCutoffCmp());
        this.dataFilterPage.setBinaryCutoffValue(a.getBinaryCutoffValue());
        this.overlappingPage.setReplaceNanValuesEnabled(a.getReplaceNanValue() != null);
        if (a.getReplaceNanValue() != null) {
            this.overlappingPage.setReplaceNanValue(a.getReplaceNanValue());
        }
        this.overlappingPage.setTransposeEnabled(a.isTransposeData());
    }

    public DataFilePage getDataFilePage() {
        return this.dataPage;
    }

    public SaveFilePage getSaveFilePage() {
        return this.saveFilePage;
    }

    public String getWorkdir() {
        return this.saveFilePage.getFolder();
    }

    public String getFileName() {
        return this.saveFilePage.getFileName();
    }

    public String getDataFileMime() {
        return this.dataPage.getFileFormat().getMime();
    }

    public File getDataFile() {
        return this.dataPage.getFile();
    }

    public File getPopulationFile() {
        return this.dataFilterPage.getRowsFilterFile();
    }
}

