/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.overlapping;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.util.ColorConstants;
import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlappingTablesPanel
extends AbstractTablesPanel<OverlappingAnalysis> {
    private static Logger log = LoggerFactory.getLogger(OverlappingTablesPanel.class);
    private static final CutoffCmp PASS_CMP = new CutoffCmp("true", "true", "true"){

        @Override
        public boolean compare(double value, double cutoff) {
            return true;
        }
    };
    private static final String DATA_TEMPLATE = "/vm/analysis/overlapping/tables_data.vm";
    private static final String RESULTS_TEMPLATE = "/vm/analysis/overlapping/tables_results.vm";
    protected Map<String, Integer> dataColIndices;
    protected IColorScale dataScale;
    protected CutoffCmp cutoffCmp;
    protected double cutoffValue;

    public OverlappingTablesPanel(OverlappingAnalysis analysis, Heatmap heatmap) {
        super(analysis, heatmap);
        IMatrix data = analysis.getData();
        int numRows = data.getRowCount();
        int numCols = data.getColumnCount();
        this.dataColIndices = new HashMap<String, Integer>();
        for (int i = 0; i < numCols; ++i) {
            this.dataColIndices.put(data.getColumnLabel(i), i);
        }
        this.dataScale = MatrixUtils.inferScale((IMatrix)data, (int)0);
        if (analysis.isBinaryCutoffEnabled()) {
            this.cutoffCmp = analysis.getBinaryCutoffCmp();
            this.cutoffValue = analysis.getBinaryCutoffValue();
        } else {
            this.cutoffCmp = PASS_CMP;
        }
    }

    @Override
    protected VelocityContext createModel() {
        IMatrixView mv = this.heatmap.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        IMatrix data = ((OverlappingAnalysis)this.analysis).getData();
        String template = DATA_TEMPLATE;
        VelocityContext context = new VelocityContext();
        switch (this.viewMode) {
            case 1: {
                template = DATA_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createDataCellModel(context, mv, row, col, data);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createDataColumnModel(context, mv, col, data);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createDataRowModel(context, mv, row, data);
                    break;
                }
                this.createDataAllModel(context, mv, data);
                break;
            }
            case 2: {
                template = RESULTS_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createResultsCellModel(context, mv, row, col);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createResultsColumnModel(context, mv, col);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createResultsRowModel(context, mv, row);
                    break;
                }
                this.createResultsAllModel(context, mv);
            }
        }
        context.put("__template__", (Object)template);
        return context;
    }

    private List<VelocityContext> createDataCellElements(IMatrixView mv, int row, int col, final IMatrix data) {
        boolean valueIndex = false;
        final MatrixUtils.DoubleCast valueCast = MatrixUtils.createDoubleCast((Class)((IElementAttribute)data.getCellAttributes().get(0)).getValueClass());
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        final int dcol1 = this.dataColIndices.get(mv.getColumnLabel(col));
        final int dcol2 = this.dataColIndices.get(mv.getColumnLabel(row));
        Integer[] iix = new Integer[data.getRowCount()];
        for (int i = 0; i < iix.length; ++i) {
            iix[i] = i;
        }
        Arrays.sort(iix, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                double v11 = valueCast.getDoubleValue(data.getCellValue(o1.intValue(), dcol1, 0));
                double v12 = valueCast.getDoubleValue(data.getCellValue(o2.intValue(), dcol1, 0));
                double v21 = valueCast.getDoubleValue(data.getCellValue(o1.intValue(), dcol2, 0));
                double v22 = valueCast.getDoubleValue(data.getCellValue(o2.intValue(), dcol2, 0));
                return (int)Math.signum(v21 + v22 - (v11 + v12));
            }
        });
        GenericFormatter fmt = new GenericFormatter();
        for (int ri = 0; ri < iix.length; ++ri) {
            int mri = iix[ri];
            double v1 = Double.NaN;
            boolean f1 = false;
            Color c1 = ColorConstants.emptyColor;
            if (data.getCell(mri, dcol1) != null) {
                v1 = valueCast.getDoubleValue(data.getCellValue(mri, dcol1, 0));
                f1 = this.cutoffCmp.compare(v1, this.cutoffValue);
                c1 = this.dataScale.valueColor(v1);
            }
            double v2 = Double.NaN;
            boolean f2 = false;
            Color c2 = ColorConstants.emptyColor;
            if (data.getCell(mri, dcol2) != null) {
                v2 = valueCast.getDoubleValue(data.getCellValue(mri, dcol2, 0));
                f2 = this.cutoffCmp.compare(v2, this.cutoffValue);
                c2 = this.dataScale.valueColor(v2);
            }
            if (Double.isNaN(v1) || !f1 || Double.isNaN(v2) || !f2) continue;
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getRowLabel(mri));
            e.put("value1", (Object)fmt.format(v1));
            e.put("color1", (Object)ColorUtils.colorToRGBHtml(c1));
            e.put("value2", (Object)fmt.format(v2));
            e.put("color2", (Object)ColorUtils.colorToRGBHtml(c2));
            elements.add(e);
        }
        return elements;
    }

    private List<VelocityContext> createDataColumnElements(IMatrixView mv, String colName, final IMatrix data) {
        boolean valueIndex = false;
        final MatrixUtils.DoubleCast valueCast = MatrixUtils.createDoubleCast((Class)data.getCellAdapter().getProperty(0).getValueClass());
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        final int dcol = this.dataColIndices.get(colName);
        Integer[] iix = new Integer[data.getRowCount()];
        for (int i = 0; i < iix.length; ++i) {
            iix[i] = i;
        }
        Arrays.sort(iix, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                double v1 = valueCast.getDoubleValue(data.getCellValue(o1.intValue(), dcol, 0));
                double v2 = valueCast.getDoubleValue(data.getCellValue(o2.intValue(), dcol, 0));
                return (int)Math.signum(v2 - v1);
            }
        });
        GenericFormatter fmt = new GenericFormatter();
        for (int ri = 0; ri < iix.length; ++ri) {
            int mri = iix[ri];
            double v1 = Double.NaN;
            boolean f1 = false;
            Color c1 = ColorConstants.emptyColor;
            if (data.getCell(mri, dcol) != null) {
                v1 = valueCast.getDoubleValue(data.getCellValue(mri, dcol, 0));
                f1 = this.cutoffCmp.compare(v1, this.cutoffValue);
                c1 = this.dataScale.valueColor(v1);
            }
            if (Double.isNaN(v1) || !f1) continue;
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getRowLabel(mri));
            e.put("value1", (Object)fmt.format(v1));
            e.put("color1", (Object)ColorUtils.colorToRGBHtml(c1));
            elements.add(e);
        }
        return elements;
    }

    private VelocityContext createDataCellModel(VelocityContext context, IMatrixView mv, int row, int col, IMatrix data) {
        List<VelocityContext> elements = this.createDataCellElements(mv, row, col, data);
        VelocityContext table = new VelocityContext();
        table.put("column1", (Object)this.truncateString(mv.getColumnLabel(col), 20));
        table.put("column2", (Object)this.truncateString(mv.getRowLabel(row), 20));
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)(mv.getColumnLabel(col) + " &lt;--&gt; " + mv.getRowLabel(row)));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataColumnModel(VelocityContext context, IMatrixView mv, int col, IMatrix data) {
        List<VelocityContext> elements = this.createDataColumnElements(mv, mv.getColumnLabel(col), data);
        VelocityContext table = new VelocityContext();
        table.put("column1", (Object)this.truncateString(mv.getColumnLabel(col), 20));
        table.put("hideColumn2", (Object)true);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataRowModel(VelocityContext context, IMatrixView mv, int row, IMatrix data) {
        List<VelocityContext> elements = this.createDataColumnElements(mv, mv.getColumnLabel(row), data);
        VelocityContext table = new VelocityContext();
        table.put("hideColumn2", (Object)true);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataAllModel(VelocityContext context, IMatrixView mv, IMatrix data) {
        return context;
    }

    private VelocityContext createResultsElement(IMatrixView mv, int row, int col) {
        GenericFormatter fmt = new GenericFormatter();
        if (col < row) {
            int tmp = col;
            col = row;
            row = tmp;
        }
        VelocityContext e = new VelocityContext();
        return e;
    }

    private VelocityContext createResultsCellModel(VelocityContext context, IMatrixView mv, int row, int col) {
        VelocityContext e = this.createResultsElement(mv, row, col);
        e.put("name", (Object)mv.getRowLabel(row));
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        elements.add(e);
        VelocityContext table = new VelocityContext();
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)(mv.getColumnLabel(col) + " &lt;--&gt; " + mv.getRowLabel(row)));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsColumnModel(VelocityContext context, IMatrixView mv, int col) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ri = 0; ri < mv.getRowCount(); ++ri) {
            VelocityContext e = this.createResultsElement(mv, ri, col);
            e.put("name", (Object)mv.getRowLabel(ri));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsRowModel(VelocityContext context, IMatrixView mv, int row) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            VelocityContext e = this.createResultsElement(mv, row, ci);
            e.put("name", (Object)mv.getColumnLabel(ci));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsAllModel(VelocityContext context, IMatrixView mv) {
        return context;
    }

    private String truncateString(String s, int len) {
        return s.substring(0, Math.min(s.length(), len));
    }
}

