/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.overlapping;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JSplitPane;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.DiagonalMatrixView;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.impl.LinearTwoSidedElementDecorator;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.gitools.ui.analysis.overlapping.OverlappingTablesPanel;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.actions.BaseAction;

public class OverlappingResultsEditor
extends HeatmapEditor {
    protected AbstractTablesPanel tablesPanel;

    protected static Heatmap createHeatmap(OverlappingAnalysis analysis) {
        DiagonalMatrixView results = new DiagonalMatrixView(analysis.getCellResults());
        Heatmap heatmap = new Heatmap((IMatrixView)results);
        heatmap.setTitle(analysis.getTitle() + " (results)");
        IElementAdapter cellAdapter = results.getCellAdapter();
        int propertiesNb = cellAdapter.getProperties().size();
        LinearTwoSidedElementDecorator[] dec = new LinearTwoSidedElementDecorator[propertiesNb];
        for (int i = 0; i < propertiesNb; ++i) {
            dec[i] = new LinearTwoSidedElementDecorator(cellAdapter);
            int valueIndex = cellAdapter.getPropertyIndex("jaccard-index");
            Color minColor = new Color(99, 220, 254);
            Color maxColor = new Color(255, 0, 95);
            dec[i].setValueIndex(valueIndex != -1 ? valueIndex : 0);
            dec[i].setMinValue(0.0);
            dec[i].setMinColor(minColor);
            dec[i].setMidValue(1.0);
            dec[i].setMidColor(maxColor);
            dec[i].setMaxValue(1.0);
            dec[i].setMaxColor(maxColor);
            dec[i].setEmptyColor(Color.WHITE);
        }
        heatmap.setCellDecorators((ElementDecorator[])dec);
        heatmap.setTitle(analysis.getTitle());
        return heatmap;
    }

    protected static List<BaseAction> createToolBar(OverlappingAnalysis analysis) {
        return null;
    }

    public OverlappingResultsEditor(OverlappingAnalysis analysis) {
        super(OverlappingResultsEditor.createHeatmap(analysis), OverlappingResultsEditor.createToolBar(analysis), true);
        this.tablesPanel = new OverlappingTablesPanel(analysis, this.heatmap);
        this.tablesPanel.setMinimumSize(new Dimension(140, 140));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setTopComponent(this.embeddedContainer);
        splitPane.setBottomComponent(this.tablesPanel);
        this.setLayout(new BorderLayout());
        this.add(splitPane);
    }
}

