/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.overlapping;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.model.ResourceRef;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.analysis.overlapping.OverlappingResultsEditor;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class OverlappingAnalysisEditor
extends AnalysisDetailsEditor<OverlappingAnalysis> {
    public OverlappingAnalysisEditor(OverlappingAnalysis analysis) {
        super(analysis, "/vm/analysis/overlapping/analysis_details.vm", null);
    }

    @Override
    protected void prepareContext(VelocityContext context) {
        ResourceRef sourceDataRes = ((OverlappingAnalysis)this.analysis).getSourceDataResource();
        context.put("sourceDataFile", (Object)(sourceDataRes != null ? sourceDataRes.getPath() : "Not defined"));
        ResourceRef filteredDataRes = ((OverlappingAnalysis)this.analysis).getFilteredDataResource();
        context.put("filteredDataFile", (Object)(filteredDataRes != null ? filteredDataRes.getPath() : "Not defined"));
        String appliedTo = ((OverlappingAnalysis)this.analysis).isTransposeData() ? "rows" : "columns";
        context.put("appliedTo", (Object)appliedTo);
        CutoffCmp cmp = ((OverlappingAnalysis)this.analysis).getBinaryCutoffCmp();
        String filterDesc = cmp == null ? "Not filtered" : "Binary cutoff filter for values " + cmp.getLongName() + " " + ((OverlappingAnalysis)this.analysis).getBinaryCutoffValue();
        context.put("filterDesc", (Object)filterDesc);
    }

    @Override
    protected void performUrlAction(String name, Map<String, String> params) {
        if ("NewDataHeatmap".equals(name)) {
            this.newDataHeatmap();
        } else if ("NewResultsHeatmap".equals(name)) {
            this.newResultsHeatmap();
        }
    }

    private void newDataHeatmap() {
        if (((OverlappingAnalysis)this.analysis).getData() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain data.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from data ...", 1);
                MatrixView dataTable = new MatrixView(((OverlappingAnalysis)OverlappingAnalysisEditor.this.analysis).getData());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((OverlappingAnalysis)OverlappingAnalysisEditor.this.analysis).getTitle() + " (data)");
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(OverlappingAnalysisEditor.this.getName(), "overlapping", "-data", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("New heatmap created.");
                    }
                });
            }
        });
    }

    private void newResultsHeatmap() {
        if (((OverlappingAnalysis)this.analysis).getCellResults() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain results.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from results ...", 1);
                MatrixView dataTable = new MatrixView(((OverlappingAnalysis)OverlappingAnalysisEditor.this.analysis).getCellResults());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((OverlappingAnalysis)OverlappingAnalysisEditor.this.analysis).getTitle() + " (results)");
                final OverlappingResultsEditor editor = new OverlappingResultsEditor((OverlappingAnalysis)OverlappingAnalysisEditor.this.analysis);
                editor.setName(editorPanel.deriveName(OverlappingAnalysisEditor.this.getName(), "overlapping", "-results", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("Heatmap for results created.");
                    }
                });
            }
        });
    }
}

