/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.gitools.model.ToolConfig;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class StatisticalTestPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -2043719552247673856L;
    public JLabel descLabel;
    public JComboBox estimatorCbox;
    public JLabel estimatorLabel;
    private JLabel jLabel1;
    private JComboBox mtcCb;
    public JComboBox samplingSizeCbox;
    public JLabel samplingSizeLabel;
    public JComboBox testCbox;

    public StatisticalTestPage() {
        this.initComponents();
        this.setTitle("Select statistical test");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setComplete(true);
        this.testCbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Test test = (Test)StatisticalTestPage.this.testCbox.getSelectedItem();
                StatisticalTestPage.this.descLabel.setText(test.description);
                boolean isZ = StatisticalTestPage.this.testCbox.getSelectedIndex() == 2;
                StatisticalTestPage.this.samplingSizeLabel.setVisible(isZ);
                StatisticalTestPage.this.samplingSizeCbox.setVisible(isZ);
                StatisticalTestPage.this.estimatorLabel.setVisible(isZ);
                StatisticalTestPage.this.estimatorCbox.setVisible(isZ);
            }
        });
        this.testCbox.setModel(new DefaultComboBoxModel<Test>(new Test[]{new Test("Binomial (Bernoulli)", ""), new Test("Fisher Exact", ""), new Test("Z Score", "")}));
        this.testCbox.setSelectedIndex(0);
        this.samplingSizeCbox.setSelectedItem(String.valueOf(10000));
        this.estimatorCbox.setModel(new DefaultComboBoxModel<String>(new String[]{"mean", "median"}));
    }

    public JComponent createControls() {
        return this;
    }

    private void initComponents() {
        this.testCbox = new JComboBox();
        this.descLabel = new JLabel();
        this.samplingSizeLabel = new JLabel();
        this.samplingSizeCbox = new JComboBox();
        this.estimatorLabel = new JLabel();
        this.estimatorCbox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.mtcCb = new JComboBox();
        this.testCbox.setModel(new DefaultComboBoxModel<String>(new String[]{"Binomial (Bernoulli)", "Fisher Exact", "Z-Score"}));
        this.descLabel.setText("Description");
        this.samplingSizeLabel.setText("Sampling size");
        this.samplingSizeCbox.setEditable(true);
        this.samplingSizeCbox.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "1000", "10000"}));
        this.samplingSizeCbox.setSelectedIndex(2);
        this.estimatorLabel.setText("Estimator");
        this.estimatorCbox.setModel(new DefaultComboBoxModel<String>(new String[]{"mean", "median"}));
        this.jLabel1.setText("Multiple test correction");
        this.mtcCb.setModel(new DefaultComboBoxModel<String>(new String[]{"Bonferroni", "Benjamini Hochberg FDR"}));
        this.mtcCb.setSelectedIndex(1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descLabel, -1, 376, Short.MAX_VALUE).addComponent(this.testCbox, 0, 376, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.estimatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.samplingSizeLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estimatorCbox, 0, 275, Short.MAX_VALUE).addComponent(this.samplingSizeCbox, 0, 275, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mtcCb, 0, 218, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.testCbox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.descLabel, -2, 59, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samplingSizeLabel).addComponent(this.samplingSizeCbox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estimatorCbox, -2, -1, -2).addComponent(this.estimatorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mtcCb, -2, -1, -2)).addContainerGap()));
    }

    public ToolConfig getTestConfig() {
        ToolConfig config = new ToolConfig("enrichment");
        switch (this.testCbox.getSelectedIndex()) {
            case 0: {
                config.put("test-name", "binomial");
                config.put("aproximation", "exact");
                break;
            }
            case 1: {
                config.put("test-name", "fisher-exact");
                break;
            }
            case 2: {
                config.put("test-name", "zscore");
                config.put("samples", this.samplingSizeCbox.getSelectedItem().toString());
                config.put("estimator", this.estimatorCbox.getSelectedItem().toString());
            }
        }
        return config;
    }

    public void setTestConfig(ToolConfig testConfig) {
        Map cfg = testConfig.getConfiguration();
        String testName = (String)cfg.get("test-name");
        int index = 0;
        if ("binomial".equals(testName)) {
            index = 0;
        } else if ("fisher-exact".equals(testName)) {
            index = 1;
        } else if ("zscore".equals(testName)) {
            index = 2;
            this.samplingSizeCbox.setSelectedItem(cfg.get("samples"));
            this.estimatorCbox.setSelectedItem(cfg.get("estimator"));
        }
        this.testCbox.setSelectedIndex(index);
        boolean vis = index == 2;
        this.samplingSizeLabel.setVisible(vis);
        this.samplingSizeCbox.setVisible(vis);
        this.estimatorLabel.setVisible(vis);
        this.estimatorCbox.setVisible(vis);
    }

    public String getMtc() {
        switch (this.mtcCb.getSelectedIndex()) {
            case 0: {
                return "bonferroni";
            }
            case 1: {
                return "bh";
            }
        }
        return "bh";
    }

    public void setMtc(String mtc) {
        if (mtc.equals("bonferroni")) {
            this.mtcCb.setSelectedIndex(0);
        } else if (mtc.equals("bh")) {
            this.mtcCb.setSelectedIndex(1);
        }
    }

    private static class Test {
        public String name;
        public String description;

        public Test(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.name;
        }
    }
}

