/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.wizard;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.io.File;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.htest.wizard.StatisticalTestPage;
import org.gitools.ui.analysis.wizard.AnalysisDetailsPage;
import org.gitools.ui.analysis.wizard.DataFilePage;
import org.gitools.ui.analysis.wizard.DataFilterPage;
import org.gitools.ui.analysis.wizard.ExamplePage;
import org.gitools.ui.analysis.wizard.ModulesPage;
import org.gitools.ui.examples.ExamplesManager;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class EnrichmentAnalysisWizard
extends AbstractWizard {
    private static final String EXAMPLE_ANALYSIS_FILE = "analysis.enrichment";
    private static final String EXAMPLE_DATA_FILE = "20_tumor_types_upreg_annot.cdm.gz";
    private static final String EXAMPLE_MODULES_FILE = "KEGG_pathways_descr__ensembl_gene.tcm";
    private ExamplePage examplePage;
    private DataFilePage dataPage;
    private DataFilterPage dataFilterPage;
    private ModulesPage modulesPage;
    private StatisticalTestPage statisticalTestPage;
    private SaveFilePage saveFilePage;
    private AnalysisDetailsPage analysisDetailsPage;

    public EnrichmentAnalysisWizard() {
        this.setTitle("Enrichment analysis");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Enrichment.png", (int)96));
        this.setHelpContext("analysis_enrichment");
    }

    public void addPages() {
        if (Settings.getDefault().isShowCombinationExamplePage()) {
            this.examplePage = new ExamplePage("an enrichment analysis");
            this.examplePage.setTitle("Enrichment analysis");
            this.addPage((IWizardPage)this.examplePage);
        }
        this.dataPage = new DataFilePage();
        this.addPage((IWizardPage)this.dataPage);
        this.dataFilterPage = new DataFilterPage();
        this.dataFilterPage.setDiscardNonMappedRowsVisible(true);
        this.addPage((IWizardPage)this.dataFilterPage);
        this.modulesPage = new ModulesPage();
        this.addPage((IWizardPage)this.modulesPage);
        this.statisticalTestPage = new StatisticalTestPage();
        this.addPage((IWizardPage)this.statisticalTestPage);
        this.saveFilePage = new SaveFilePage();
        this.saveFilePage.setTitle("Select destination file");
        this.saveFilePage.setFolder(Settings.getDefault().getLastWorkPath());
        this.saveFilePage.setFormats(new FileFormat[]{new FileFormat("Enrichment analysis (*.enrichment)", "enrichment")});
        this.saveFilePage.setFormatsVisible(false);
        this.addPage((IWizardPage)this.saveFilePage);
        this.analysisDetailsPage = new AnalysisDetailsPage();
        this.addPage((IWizardPage)this.analysisDetailsPage);
    }

    public void pageLeft(IWizardPage currentPage) {
        if (currentPage == this.examplePage) {
            Settings.getDefault().setShowCombinationExamplePage(this.examplePage.isShowAgain());
            if (this.examplePage.isExampleEnabled()) {
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        final File basePath = ExamplesManager.getDefault().resolvePath("enrichment", monitor);
                        if (basePath == null) {
                            throw new RuntimeException("Unexpected error: There are no examples available");
                        }
                        File analysisFile = new File(basePath, EnrichmentAnalysisWizard.EXAMPLE_ANALYSIS_FILE);
                        Properties props = new Properties();
                        props.setProperty("load_references", "false");
                        try {
                            monitor.begin("Loading example parameters ...", 1);
                            final EnrichmentAnalysis a = (EnrichmentAnalysis)PersistenceManager.getDefault().load(analysisFile, props, monitor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    EnrichmentAnalysisWizard.this.setAnalysis(a);
                                    EnrichmentAnalysisWizard.this.dataPage.setFile(new File(basePath, EnrichmentAnalysisWizard.EXAMPLE_DATA_FILE));
                                    EnrichmentAnalysisWizard.this.modulesPage.setSelectedFile(new File(basePath, EnrichmentAnalysisWizard.EXAMPLE_MODULES_FILE));
                                    EnrichmentAnalysisWizard.this.saveFilePage.setFileNameWithoutExtension("example");
                                }
                            });
                            monitor.end();
                        }
                        catch (Exception ex) {
                            monitor.exception(ex);
                        }
                    }
                });
            }
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getCurrentPage();
        boolean canFinish = super.canFinish();
        return canFinish |= page == this.saveFilePage && page.isComplete();
    }

    public void performCancel() {
        super.performCancel();
    }

    public void performFinish() {
        Settings.getDefault().setLastWorkPath(this.saveFilePage.getFolder());
    }

    public String getWorkdir() {
        return this.saveFilePage.getFolder();
    }

    public String getFileName() {
        return this.saveFilePage.getFileName();
    }

    public String getDataFileMime() {
        return this.dataPage.getFileFormat().getMime();
    }

    public File getDataFile() {
        return this.dataPage.getFile();
    }

    public File getPopulationFile() {
        return this.dataFilterPage.getRowsFilterFile();
    }

    public Double getPopulationDefaultValue() {
        return this.dataFilterPage.getPopulationDefaultValue();
    }

    public String getModulesFileMime() {
        return this.modulesPage.getFileMime();
    }

    public File getModulesFile() {
        return this.modulesPage.getSelectedFile();
    }

    public EnrichmentAnalysis getAnalysis() {
        EnrichmentAnalysis analysis = new EnrichmentAnalysis();
        analysis.setTitle(this.analysisDetailsPage.getAnalysisTitle());
        analysis.setDescription(this.analysisDetailsPage.getAnalysisNotes());
        analysis.setAttributes(this.analysisDetailsPage.getAnalysisAttributes());
        analysis.setBinaryCutoffEnabled(this.dataFilterPage.isBinaryCutoffEnabled());
        analysis.setBinaryCutoffCmp(this.dataFilterPage.getBinaryCutoffCmp());
        analysis.setBinaryCutoffValue(this.dataFilterPage.getBinaryCutoffValue());
        analysis.setDiscardNonMappedRows(this.dataFilterPage.isDiscardNonMappedRowsEnabled());
        analysis.setMinModuleSize(this.modulesPage.getMinSize());
        analysis.setMaxModuleSize(this.modulesPage.getMaxSize());
        analysis.setTestConfig(this.statisticalTestPage.getTestConfig());
        analysis.setMtc(this.statisticalTestPage.getMtc());
        return analysis;
    }

    private void setAnalysis(EnrichmentAnalysis a) {
        this.analysisDetailsPage.setAnalysisTitle(a.getTitle());
        this.analysisDetailsPage.setAnalysisNotes(a.getDescription());
        this.analysisDetailsPage.setAnalysisAttributes(a.getAttributes());
        this.dataFilterPage.setBinaryCutoffEnabled(a.isBinaryCutoffEnabled());
        this.dataFilterPage.setBinaryCutoffCmp(a.getBinaryCutoffCmp());
        this.dataFilterPage.setBinaryCutoffValue(a.getBinaryCutoffValue());
        this.modulesPage.setMinSize(a.getMinModuleSize());
        this.modulesPage.setMaxSize(a.getMaxModuleSize());
        this.statisticalTestPage.setTestConfig(a.getTestConfig());
        this.statisticalTestPage.setMtc(a.getMtc());
    }
}

