/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.editor.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.model.ModuleMap;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;

public class ViewRelatedDataFromRowAction
extends BaseAction {
    protected String title;
    protected IMatrix matrix;
    protected ModuleMap map;

    public ViewRelatedDataFromRowAction(String title, IMatrix matrix, ModuleMap map) {
        super("View annotated elements");
        this.setDesc("View annotated elements in a new heatmap");
        this.setLargeIconFromResource("/img/ViewAnnotatedElements24.gif");
        this.setSmallIconFromResource("/img/ViewAnnotatedElements16.gif");
        this.title = title;
        this.matrix = matrix;
        this.map = map;
    }

    public void actionPerformed(ActionEvent e) {
        EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        AbstractEditor currentEditor = editorPanel.getSelectedEditor();
        Heatmap srcHeatmap = (Heatmap)currentEditor.getModel();
        IMatrixView srcMatrixView = srcHeatmap.getMatrixView();
        IMatrix srcMatrix = srcMatrixView.getContents();
        int[] selRows = srcMatrixView.getSelectedRows();
        int leadRow = srcMatrixView.getLeadSelectionRow();
        if ((selRows == null || selRows.length == 0) && leadRow != -1) {
            selRows = new int[]{leadRow};
        } else if (leadRow == -1) {
            JOptionPane.showMessageDialog(AppFrame.instance(), "You must select some rows before.", "Error", 0);
            return;
        }
        int[] view = srcMatrixView.getVisibleRows();
        HashSet<Integer> elements = new HashSet<Integer>();
        HashMap<String, Integer> itemNameMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.matrix.getRowCount(); ++i) {
            itemNameMap.put(this.matrix.getRowLabel(i), i);
        }
        StringBuilder moduleNames = new StringBuilder();
        for (int i = 0; i < selRows.length; ++i) {
            String modName = srcMatrix.getRowLabel(view[selRows[i]]);
            if (i != 0) {
                moduleNames.append(", ");
            }
            moduleNames.append(modName);
            int[] indices = this.map.getItemIndices(modName);
            if (indices == null) continue;
            for (int index : indices) {
                String itemName = this.map.getItemName(index);
                Integer dstIndex = (Integer)itemNameMap.get(itemName);
                if (dstIndex == null) continue;
                elements.add(dstIndex);
            }
        }
        int[] newView = new int[elements.size()];
        int i = 0;
        for (Integer index : elements) {
            newView[i++] = index;
        }
        MatrixView matrixView = new MatrixView(this.matrix);
        matrixView.setVisibleRows(newView);
        Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)matrixView);
        heatmap.setTitle(this.title);
        heatmap.setDescription("Annotated elements for modules: " + moduleNames.toString());
        HeatmapEditor editor = new HeatmapEditor(heatmap);
        editor.setName(editorPanel.deriveName(currentEditor.getName(), "heatmap", "-data", "heatmap"));
        editorPanel.addEditor((AbstractEditor)editor);
        AppFrame.instance().setStatusText("New heatmap created.");
    }
}

