/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.editor;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.model.ModuleMap;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.gitools.ui.analysis.htest.editor.EnrichmentTablesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncodriveTablesPanel
extends AbstractTablesPanel<OncodriveAnalysis> {
    private static Logger log = LoggerFactory.getLogger(EnrichmentTablesPanel.class);
    private static final String DATA_TEMPLATE = "/vm/analysis/oncodrive/tables_data.vm";
    private static final String RESULTS_TEMPLATE = "/vm/analysis/oncodrive/tables_results.vm";
    protected final int dataValueIndex = 0;
    protected Map<String, Integer> dataRowIndices;
    protected Map<String, Integer> dataColIndices;
    protected ModuleMap mmap;
    protected IColorScale dataScale;

    public OncodriveTablesPanel(OncodriveAnalysis analysis, Heatmap heatmap) {
        super(analysis, heatmap);
        int i;
        IMatrix data = analysis.getData();
        int numRows = data.getRowCount();
        int numCols = data.getColumnCount();
        this.dataRowIndices = new HashMap<String, Integer>();
        for (i = 0; i < numRows; ++i) {
            this.dataRowIndices.put(data.getRowLabel(i), i);
        }
        this.dataColIndices = new HashMap<String, Integer>();
        for (i = 0; i < numCols; ++i) {
            this.dataColIndices.put(data.getColumnLabel(i), i);
        }
        String[] labels = new String[numCols];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            labels[i2] = data.getColumnLabel(i2);
        }
        this.mmap = analysis.getModuleMap();
        if (this.mmap != null) {
            this.mmap = this.mmap.remap(labels);
        } else {
            int i3;
            IMatrixView mv = heatmap.getMatrixView();
            String[] groups = new String[mv.getColumnCount()];
            for (int i4 = 0; i4 < groups.length; ++i4) {
                groups[i4] = mv.getColumnLabel(i4);
            }
            this.mmap = new ModuleMap();
            this.mmap.setModuleNames(groups);
            this.mmap.setItemNames(labels);
            int[] indices = new int[numCols];
            for (i3 = 0; i3 < indices.length; ++i3) {
                indices[i3] = i3;
            }
            for (i3 = 0; i3 < groups.length; ++i3) {
                this.mmap.setItemIndices(i3, indices);
            }
        }
        this.dataScale = MatrixUtils.inferScale((IMatrix)data, (int)0);
    }

    @Override
    protected VelocityContext createModel() {
        IMatrixView mv = this.heatmap.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        IMatrix data = ((OncodriveAnalysis)this.analysis).getData();
        String template = DATA_TEMPLATE;
        VelocityContext context = new VelocityContext();
        switch (this.viewMode) {
            case 1: {
                template = DATA_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createDataCellModel(context, mv, row, col, data, this.mmap);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createDataColumnModel(context, mv, col, data, this.mmap);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createDataRowModel(context, mv, row, data, this.mmap);
                    break;
                }
                this.createDataAllModel(context, mv, data, this.mmap);
                break;
            }
            case 2: {
                template = RESULTS_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createResultsCellModel(context, mv, row, col);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createResultsColumnModel(context, mv, col);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createResultsRowModel(context, mv, row);
                    break;
                }
                this.createResultsAllModel(context, mv);
            }
        }
        context.put("__template__", (Object)template);
        return context;
    }

    private List<VelocityContext> createDataElements(IMatrixView mv, int row, int col, final IMatrix data, ModuleMap mmap) {
        final MatrixUtils.DoubleCast valueCast = MatrixUtils.createDoubleCast((Class)data.getCellAdapter().getProperty(0).getValueClass());
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        String mname = mv.getColumnLabel(col);
        int[] indices = mmap.getItemIndices(mname);
        final int drow = this.dataRowIndices.get(mv.getRowLabel(row));
        Integer[] iix = new Integer[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            iix[i] = indices[i];
        }
        Arrays.sort(iix, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                double v1 = valueCast.getDoubleValue(data.getCellValue(drow, o1.intValue(), 0));
                double v2 = valueCast.getDoubleValue(data.getCellValue(drow, o2.intValue(), 0));
                return (int)Math.signum(v2 - v1);
            }
        });
        GenericFormatter fmt = new GenericFormatter();
        for (int ci = 0; ci < iix.length; ++ci) {
            int mci = iix[ci];
            if (data.getCell(drow, mci) == null) continue;
            double value = valueCast.getDoubleValue(data.getCellValue(drow, mci, 0));
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getColumnLabel(mci));
            e.put("value", (Object)fmt.format(value));
            e.put("color", (Object)ColorUtils.colorToRGBHtml(this.dataScale.valueColor(value)));
            elements.add(e);
        }
        return elements;
    }

    private VelocityContext createDataTableElements(IMatrixView mv, int row, int col, IMatrix data, ModuleMap mmap) {
        List<VelocityContext> elements = this.createDataElements(mv, row, col, data, mmap);
        VelocityContext table = new VelocityContext();
        table.put("name", (Object)mv.getRowLabel(row));
        table.put("elements", elements);
        return table;
    }

    private VelocityContext createDataCellModel(VelocityContext context, IMatrixView mv, int row, int col, IMatrix data, ModuleMap mmap) {
        VelocityContext table = this.createDataTableElements(mv, row, col, data, mmap);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataColumnModel(VelocityContext context, IMatrixView mv, int col, IMatrix data, ModuleMap mmap) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        String mname = mv.getColumnLabel(col);
        int[] iix = mmap.getItemIndices(mname);
        for (int ci = 0; ci < iix.length; ++ci) {
            int mci = iix[ci];
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getColumnLabel(mci));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("hideValues", (Object)true);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataRowModel(VelocityContext context, IMatrixView mv, int row, IMatrix data, ModuleMap mmap) {
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        for (int col = 0; col < mv.getColumnCount(); ++col) {
            ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
            String mname = mv.getColumnLabel(col);
            int[] iix = mmap.getItemIndices(mname);
            for (int ci = 0; ci < iix.length; ++ci) {
                int mci = iix[ci];
                VelocityContext e = new VelocityContext();
                e.put("name", (Object)data.getColumnLabel(mci));
                elements.add(e);
            }
            VelocityContext table = new VelocityContext();
            table.put("hideValues", (Object)true);
            table.put("elements", elements);
            tables.add(table);
        }
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataAllModel(VelocityContext context, IMatrixView mv, IMatrix data, ModuleMap mmap) {
        return context;
    }

    private VelocityContext createResultsElement(IMatrixView mv, int row, int col) {
        GenericFormatter fmt = new GenericFormatter();
        String pvalueAttrName = "right-p-value";
        String cpvalueAttrName = "corrected-right-p-value";
        int pvalueIndex = mv.getCellAdapter().getPropertyIndex(pvalueAttrName);
        double pvalue = MatrixUtils.doubleValue((Object)mv.getCellValue(row, col, pvalueIndex));
        int cpvalueIndex = mv.getCellAdapter().getPropertyIndex(cpvalueAttrName);
        double cpvalue = MatrixUtils.doubleValue((Object)mv.getCellValue(row, col, cpvalueIndex));
        PValueColorScale pscale = new PValueColorScale();
        VelocityContext e = new VelocityContext();
        e.put("pvalue", (Object)fmt.pvalue(pvalue));
        e.put("pvalue_color", (Object)ColorUtils.colorToRGBHtml(pscale.valueColor(pvalue)));
        e.put("cpvalue", (Object)fmt.pvalue(cpvalue));
        e.put("cpvalue_color", (Object)ColorUtils.colorToRGBHtml(pscale.valueColor(cpvalue)));
        return e;
    }

    private VelocityContext createResultsCellModel(VelocityContext context, IMatrixView mv, int row, int col) {
        VelocityContext e = this.createResultsElement(mv, row, col);
        e.put("name", (Object)mv.getRowLabel(row));
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        elements.add(e);
        VelocityContext table = new VelocityContext();
        table.put("name", (Object)mv.getRowLabel(row));
        table.put("vaCount", (Object)0);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsColumnModel(VelocityContext context, IMatrixView mv, int col) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ri = 0; ri < mv.getRowCount(); ++ri) {
            VelocityContext e = this.createResultsElement(mv, ri, col);
            e.put("name", (Object)mv.getRowLabel(ri));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("vaCount", (Object)0);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsRowModel(VelocityContext context, IMatrixView mv, int row) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            VelocityContext e = this.createResultsElement(mv, row, ci);
            e.put("name", (Object)mv.getColumnLabel(ci));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("vaCount", (Object)0);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsAllModel(VelocityContext context, IMatrixView mv) {
        return context;
    }
}

