/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.editor;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.analysis.htest.editor.OncodriveResultsEditor;
import org.gitools.ui.dialog.UnimplementedDialog;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class OncodriveAnalysisEditor
extends AnalysisDetailsEditor<OncodriveAnalysis> {
    public OncodriveAnalysisEditor(OncodriveAnalysis analysis) {
        super(analysis, "/vm/analysis/oncodrive/analysis_details.vm", null);
    }

    @Override
    protected void prepareContext(VelocityContext context) {
        PersistenceManager.FileRef fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((OncodriveAnalysis)this.analysis).getData());
        context.put("dataFile", (Object)(fileRef != null ? fileRef.getFile().getName() : "Not defined"));
        CutoffCmp cmp = ((OncodriveAnalysis)this.analysis).getBinaryCutoffCmp();
        String filterDesc = cmp == null ? "Not filtered" : "Binary cutoff filter for values " + cmp.getLongName() + " " + ((OncodriveAnalysis)this.analysis).getBinaryCutoffValue();
        context.put("filterDesc", (Object)filterDesc);
        fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((OncodriveAnalysis)this.analysis).getModuleMap());
        context.put("modulesFile", (Object)(fileRef != null ? fileRef.getFile().getName() : "Unknown"));
        context.put("moduleMinSize", (Object)((OncodriveAnalysis)this.analysis).getMinModuleSize());
        int maxSize = ((OncodriveAnalysis)this.analysis).getMaxModuleSize();
        context.put("moduleMaxSize", maxSize != Integer.MAX_VALUE ? Integer.valueOf(maxSize) : "No limit");
        if (((OncodriveAnalysis)this.analysis).getMtc().equals("bh")) {
            context.put("mtc", (Object)"Benjamini Hochberg FDR");
        } else if (((OncodriveAnalysis)this.analysis).getMtc().equals("bonferroni")) {
            context.put("mtc", (Object)"Bonferroni");
        }
    }

    @Override
    protected void performUrlAction(String name, Map<String, String> params) {
        if ("NewDataHeatmap".equals(name)) {
            this.newDataHeatmap();
        } else if ("ViewModuleMap".equals(name)) {
            this.viewModuleMap();
        } else if ("NewResultsHeatmap".equals(name)) {
            this.newResultsHeatmap();
        }
    }

    private void newDataHeatmap() {
        if (((OncodriveAnalysis)this.analysis).getData() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain data.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from data ...", 1);
                MatrixView dataTable = new MatrixView(((OncodriveAnalysis)OncodriveAnalysisEditor.this.analysis).getData());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((OncodriveAnalysis)OncodriveAnalysisEditor.this.analysis).getTitle() + " (data)");
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(OncodriveAnalysisEditor.this.getName(), "oncodrive", "-data", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("New heatmap created.");
                    }
                });
            }
        });
    }

    private void viewModuleMap() {
        UnimplementedDialog.show(AppFrame.instance());
    }

    private void newResultsHeatmap() {
        if (((OncodriveAnalysis)this.analysis).getResults() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain results.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from results ...", 1);
                MatrixView dataTable = new MatrixView((IMatrix)((OncodriveAnalysis)OncodriveAnalysisEditor.this.analysis).getResults());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((OncodriveAnalysis)OncodriveAnalysisEditor.this.analysis).getTitle() + " (results)");
                final OncodriveResultsEditor editor = new OncodriveResultsEditor((OncodriveAnalysis)OncodriveAnalysisEditor.this.analysis);
                editor.setName(editorPanel.deriveName(OncodriveAnalysisEditor.this.getName(), "oncodrive", "-results", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("Heatmap for oncodrive results created.");
                    }
                });
            }
        });
    }
}

