/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.editor;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.ModuleMap;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentTablesPanel
extends AbstractTablesPanel<EnrichmentAnalysis> {
    private static Logger log = LoggerFactory.getLogger(EnrichmentTablesPanel.class);
    private static final String DATA_TEMPLATE = "/vm/analysis/enrichment/tables_data.vm";
    private static final String RESULTS_TEMPLATE = "/vm/analysis/enrichment/tables_results.vm";
    protected Map<String, Integer> dataRowIndices;
    protected Map<String, Integer> dataColIndices;
    protected ModuleMap mmap;
    protected IColorScale dataScale;

    public EnrichmentTablesPanel(EnrichmentAnalysis analysis, Heatmap heatmap) {
        super(analysis, heatmap);
        int i;
        IMatrix data = analysis.getData();
        int numRows = data.getRowCount();
        int numCols = data.getColumnCount();
        this.dataRowIndices = new HashMap<String, Integer>();
        for (i = 0; i < numRows; ++i) {
            this.dataRowIndices.put(data.getRowLabel(i), i);
        }
        this.dataColIndices = new HashMap<String, Integer>();
        for (i = 0; i < numCols; ++i) {
            this.dataColIndices.put(data.getColumnLabel(i), i);
        }
        String[] labels = new String[numRows];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            labels[i2] = data.getRowLabel(i2);
        }
        this.mmap = analysis.getModuleMap().remap(labels);
        this.dataScale = MatrixUtils.inferScale((IMatrix)data, (int)0);
    }

    @Override
    protected VelocityContext createModel() {
        IMatrixView mv = this.heatmap.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        IMatrix data = ((EnrichmentAnalysis)this.analysis).getData();
        String template = DATA_TEMPLATE;
        VelocityContext context = new VelocityContext();
        switch (this.viewMode) {
            case 1: {
                template = DATA_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createDataCellModel(context, mv, row, col, data, this.mmap);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createDataColumnModel(context, mv, col, data, this.mmap);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createDataRowModel(context, mv, row, data, this.mmap);
                    break;
                }
                this.createDataAllModel(context, mv, data, this.mmap);
                break;
            }
            case 2: {
                template = RESULTS_TEMPLATE;
                if (row != -1 && col != -1) {
                    this.createResultsCellModel(context, mv, row, col);
                    break;
                }
                if (row == -1 && col != -1) {
                    this.createResultsColumnModel(context, mv, col);
                    break;
                }
                if (row != -1 && col == -1) {
                    this.createResultsRowModel(context, mv, row);
                    break;
                }
                this.createResultsAllModel(context, mv);
            }
        }
        context.put("__template__", (Object)template);
        return context;
    }

    private List<VelocityContext> createDataElements(IMatrixView mv, int row, int col, final IMatrix data, ModuleMap mmap) {
        boolean valueIndex = false;
        final MatrixUtils.DoubleCast valueCast = MatrixUtils.createDoubleCast((Class)data.getCellAdapter().getProperty(0).getValueClass());
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        final int dcol = this.dataColIndices.get(mv.getColumnLabel(col));
        String mname = mv.getRowLabel(row);
        int[] indices = mmap.getItemIndices(mname);
        Integer[] iix = new Integer[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            iix[i] = indices[i];
        }
        Arrays.sort(iix, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                double v1 = valueCast.getDoubleValue(data.getCellValue(o1.intValue(), dcol, 0));
                double v2 = valueCast.getDoubleValue(data.getCellValue(o2.intValue(), dcol, 0));
                return (int)Math.signum(v2 - v1);
            }
        });
        GenericFormatter fmt = new GenericFormatter();
        for (int ri = 0; ri < iix.length; ++ri) {
            int mri = iix[ri];
            if (data.getCell(mri, dcol) == null) continue;
            double value = valueCast.getDoubleValue(data.getCellValue(mri, dcol, 0));
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getRowLabel(mri));
            e.put("value", (Object)fmt.format(value));
            e.put("color", (Object)ColorUtils.colorToRGBHtml(this.dataScale.valueColor(value)));
            elements.add(e);
        }
        return elements;
    }

    private VelocityContext createDataTableElements(IMatrixView mv, int row, int col, IMatrix data, ModuleMap mmap) {
        List<VelocityContext> elements = this.createDataElements(mv, row, col, data, mmap);
        VelocityContext table = new VelocityContext();
        table.put("name", (Object)mv.getRowLabel(row));
        table.put("elements", elements);
        return table;
    }

    private VelocityContext createDataCellModel(VelocityContext context, IMatrixView mv, int row, int col, IMatrix data, ModuleMap mmap) {
        VelocityContext table = this.createDataTableElements(mv, row, col, data, mmap);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataColumnModel(VelocityContext context, IMatrixView mv, int col, IMatrix data, ModuleMap mmap) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        int numRows = mv.getRowCount();
        for (int ri = 0; ri < numRows; ++ri) {
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)mv.getRowLabel(ri));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("hideValues", (Object)true);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataRowModel(VelocityContext context, IMatrixView mv, int row, IMatrix data, ModuleMap mmap) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        String mname = mv.getRowLabel(row);
        int[] iix = mmap.getItemIndices(mname);
        for (int ri = 0; ri < iix.length; ++ri) {
            int mri = iix[ri];
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getRowLabel(mri));
            elements.add(e);
        }
        VelocityContext table = new VelocityContext();
        table.put("hideValues", (Object)true);
        table.put("elements", elements);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createDataAllModel(VelocityContext context, IMatrixView mv, IMatrix data, ModuleMap mmap) {
        return context;
    }

    private VelocityContext createHeader(IMatrixView mv) {
        ArrayList<String> headerIds = new ArrayList<String>();
        ArrayList<String> headerNames = new ArrayList<String>();
        ArrayList<Boolean> isColor = new ArrayList<Boolean>();
        for (IElementAttribute a : mv.getCellAttributes()) {
            String id = a.getId();
            if (id.equals("distribution")) continue;
            if (id.contains("p-value")) {
                headerIds.add(a.getId() + "-color");
                headerNames.add("");
                isColor.add(true);
            }
            headerIds.add(a.getId());
            headerNames.add(a.getName());
            isColor.add(false);
        }
        VelocityContext header = new VelocityContext();
        header.put("ids", headerIds);
        header.put("names", headerNames);
        header.put("isColor", isColor);
        return header;
    }

    private VelocityContext createResultsElement(IMatrixView mv, int row, int col) {
        GenericFormatter fmt = new GenericFormatter();
        PValueColorScale pscale = new PValueColorScale();
        VelocityContext e = new VelocityContext();
        for (IElementAttribute a : mv.getCellAttributes()) {
            String id = a.getId();
            Object value = mv.getCellValue(row, col, id);
            if (id.equals("distribution")) continue;
            if (id.contains("p-value")) {
                double pvalue = MatrixUtils.doubleValue((Object)value);
                e.put(id, (Object)fmt.pvalue(pvalue));
                e.put(id + "-color", (Object)ColorUtils.colorToRGBHtml(pscale.valueColor(pvalue)));
                continue;
            }
            e.put(id, (Object)fmt.format(value));
        }
        return e;
    }

    private VelocityContext createResultsCellModel(VelocityContext context, IMatrixView mv, int row, int col) {
        VelocityContext e = this.createResultsElement(mv, row, col);
        e.put("name", (Object)mv.getRowLabel(row));
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        elements.add(e);
        VelocityContext header = this.createHeader(mv);
        VelocityContext table = new VelocityContext();
        table.put("name", (Object)mv.getRowLabel(row));
        table.put("vaCount", (Object)((List)header.get("ids")).size());
        table.put("elements", elements);
        table.put("header", (Object)header);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsColumnModel(VelocityContext context, IMatrixView mv, int col) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ri = 0; ri < mv.getRowCount(); ++ri) {
            VelocityContext e = this.createResultsElement(mv, ri, col);
            e.put("name", (Object)mv.getRowLabel(ri));
            elements.add(e);
        }
        VelocityContext header = this.createHeader(mv);
        VelocityContext table = new VelocityContext();
        table.put("vaCount", (Object)((List)header.get("ids")).size());
        table.put("elements", elements);
        table.put("header", (Object)header);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getColumnLabel(col));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsRowModel(VelocityContext context, IMatrixView mv, int row) {
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            VelocityContext e = this.createResultsElement(mv, row, ci);
            e.put("name", (Object)mv.getColumnLabel(ci));
            elements.add(e);
        }
        VelocityContext header = this.createHeader(mv);
        VelocityContext table = new VelocityContext();
        table.put("vaCount", (Object)((List)header.get("ids")).size());
        table.put("elements", elements);
        table.put("header", (Object)header);
        ArrayList<VelocityContext> tables = new ArrayList<VelocityContext>();
        tables.add(table);
        VelocityContext section = new VelocityContext();
        section.put("name", (Object)mv.getRowLabel(row));
        section.put("tables", tables);
        ArrayList<VelocityContext> sections = new ArrayList<VelocityContext>();
        sections.add(section);
        context.put("sections", sections);
        return context;
    }

    private VelocityContext createResultsAllModel(VelocityContext context, IMatrixView mv) {
        return context;
    }
}

