/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.htest.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSplitPane;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.gitools.ui.analysis.htest.editor.EnrichmentTablesPanel;
import org.gitools.ui.analysis.htest.editor.actions.ViewRelatedDataFromRowAction;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.actions.BaseAction;

public class EnrichmentResultsEditor
extends HeatmapEditor {
    protected EnrichmentAnalysis analysis;
    protected AbstractTablesPanel tablesPanel;

    protected static Heatmap createHeatmap(EnrichmentAnalysis analysis) {
        MatrixView dataTable = new MatrixView((IMatrix)analysis.getResults());
        Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
        heatmap.setTitle(analysis.getTitle() + " (results)");
        return heatmap;
    }

    protected static List<BaseAction> createToolBar(EnrichmentAnalysis analysis) {
        ViewRelatedDataFromRowAction action = new ViewRelatedDataFromRowAction(analysis.getTitle(), analysis.getData(), analysis.getModuleMap());
        ArrayList<BaseAction> tb = new ArrayList<BaseAction>();
        tb.add(action);
        return tb;
    }

    public EnrichmentResultsEditor(EnrichmentAnalysis analysis) {
        super(EnrichmentResultsEditor.createHeatmap(analysis), EnrichmentResultsEditor.createToolBar(analysis), true);
        this.tablesPanel = new EnrichmentTablesPanel(analysis, this.heatmap);
        this.tablesPanel.setMinimumSize(new Dimension(140, 140));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setTopComponent(this.embeddedContainer);
        splitPane.setBottomComponent(this.tablesPanel);
        this.setLayout(new BorderLayout());
        this.add(splitPane);
    }
}

