/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.groupcomparison.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.gitools.analysis.groupcomparison.GroupComparisonAnalysis;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.stats.mtc.BenjaminiHochbergFdr;
import org.gitools.stats.mtc.Bonferroni;
import org.gitools.stats.mtc.MTC;
import org.gitools.stats.test.MannWhitneyWilxoxonTest;
import org.gitools.stats.test.Test;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class GroupComparisonSelectAttributePage
extends AbstractWizardPage {
    private ButtonGroup applyGroup;
    private JComboBox attributeCb;
    private JLabel attributeLabel;
    private JLabel attributeLabel1;
    private JLabel attributeLabel2;
    private JLabel attributeLabel3;
    private JLabel attributeLabel4;
    private JComboBox columnGroupingCb;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JComboBox mtcCb;
    public JComboBox testCbox;

    public GroupComparisonSelectAttributePage() {
        this.initComponents();
        this.setTitle("Select data and statistical test");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setComplete(true);
        this.testCbox.setModel(new DefaultComboBoxModel<TestElement>(new TestElement[]{new TestElement((Test)new MannWhitneyWilxoxonTest())}));
        this.mtcCb.setModel(new DefaultComboBoxModel<MTCElement>(new MTCElement[]{new MTCElement((MTC)new BenjaminiHochbergFdr()), new MTCElement((MTC)new Bonferroni())}));
        this.columnGroupingCb.setModel(new DefaultComboBoxModel<String>(GroupComparisonAnalysis.getColumnGroupingMethods()));
    }

    public Test getTest() {
        TestElement testElement = (TestElement)this.testCbox.getModel().getSelectedItem();
        return testElement.getTest();
    }

    public MTC getMtc() {
        MTCElement mtcElement = (MTCElement)this.mtcCb.getModel().getSelectedItem();
        return mtcElement.getMTC();
    }

    public String getColumnGrouping() {
        return (String)this.columnGroupingCb.getSelectedItem();
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.attributeLabel = new JLabel();
        this.attributeCb = new JComboBox();
        this.testCbox = new JComboBox();
        this.attributeLabel1 = new JLabel();
        this.jLabel1 = new JLabel();
        this.mtcCb = new JComboBox();
        this.attributeLabel2 = new JLabel();
        this.columnGroupingCb = new JComboBox();
        this.attributeLabel3 = new JLabel();
        this.attributeLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.attributeLabel.setText("Take values to compare from:");
        this.testCbox.setModel(new DefaultComboBoxModel<String>(new String[]{"Mann-Whitney-Wilcoxon"}));
        this.testCbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonSelectAttributePage.this.testCboxActionPerformed(evt);
            }
        });
        this.attributeLabel1.setText("Select Test");
        this.jLabel1.setText("Multiple test correction");
        this.mtcCb.setModel(new DefaultComboBoxModel<String>(new String[]{"Bonferroni", "Benjamini Hochberg FDR"}));
        this.mtcCb.setSelectedIndex(1);
        this.attributeLabel2.setText("Group columns by:");
        this.attributeLabel3.setText("Data:");
        this.attributeLabel4.setText("Statistics:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 525, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributeLabel2).addComponent(this.attributeLabel)).addGap(45, 45, 45).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.columnGroupingCb, 0, 275, Short.MAX_VALUE).addComponent(this.attributeCb, GroupLayout.Alignment.LEADING, 0, 275, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.attributeLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testCbox, 0, 349, Short.MAX_VALUE).addComponent(this.mtcCb, 0, 349, Short.MAX_VALUE))).addComponent(this.attributeLabel4).addComponent(this.attributeLabel3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.attributeLabel3).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeLabel).addComponent(this.attributeCb, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeLabel2).addComponent(this.columnGroupingCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.attributeLabel4).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testCbox, -2, -1, -2).addComponent(this.attributeLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mtcCb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void testCboxActionPerformed(ActionEvent evt) {
    }

    public JComponent createControls() {
        return this;
    }

    public void setAttributes(List<IElementAttribute> attrs) {
        if (attrs != null) {
            AttrOption[] attrOptions = new AttrOption[attrs.size()];
            for (int i = 0; i < attrs.size(); ++i) {
                attrOptions[i] = new AttrOption(attrs.get(i));
            }
            this.attributeCb.setModel(new DefaultComboBoxModel<AttrOption>(attrOptions));
            this.attributeCb.setSelectedIndex(0);
            this.attributeCb.setEnabled(true);
            this.attributeCb.setVisible(true);
            this.attributeLabel.setVisible(true);
        } else {
            this.dissableAttrCb();
        }
    }

    private void dissableAttrCb() {
        this.attributeCb.setModel(new DefaultComboBoxModel());
        this.attributeCb.setEnabled(false);
        this.attributeCb.setVisible(false);
        this.attributeLabel.setVisible(false);
    }

    public int getAttributeIndex() {
        return this.attributeCb.getSelectedIndex();
    }

    public class AttrOption {
        private String name;
        private IElementAttribute attr;

        public AttrOption(String name) {
            this.name = name;
        }

        public AttrOption(IElementAttribute attr) {
            this.attr = attr;
        }

        public IElementAttribute getAttr() {
            return this.attr;
        }

        public String toString() {
            return this.attr != null ? this.attr.getName() : this.name;
        }
    }

    private static class MTCElement {
        public MTC mtc;

        public MTCElement(MTC mtc) {
            this.mtc = mtc;
        }

        public String toString() {
            return this.mtc.getName();
        }

        public MTC getMTC() {
            return this.mtc;
        }
    }

    private static class TestElement {
        public Test test;

        public TestElement(Test test) {
            this.test = test;
        }

        public String toString() {
            return this.test.getName();
        }

        public Test getTest() {
            return this.test;
        }
    }
}

