/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.groupcomparison.wizard;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class GroupComparisonGroupingByValuePage
extends AbstractWizardPage {
    private static final long serialVersionUID = 3840797252370672587L;
    private JLabel attributeLabel;
    private JLabel attributeLabel1;
    private JLabel attributeLabel2;
    private JLabel attributeLabel3;
    private JLabel attributeLabel4;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox cutoffAttributeSelect;
    private JComboBox cutoffCmpGroup1Cb;
    private JComboBox cutoffCmpGroup2Cb;
    private JTextField cutoffValueGroup1;
    private JTextField cutoffValueGroup2;

    public GroupComparisonGroupingByValuePage() {
        this.setTitle("Select data filtering options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Data.png", (int)96));
        this.initComponents();
        DocumentChangeListener docCompleteListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                GroupComparisonGroupingByValuePage.this.updateState(e);
            }
        };
        String[] cmpNames = new String[CutoffCmp.comparators.length];
        for (int i = 0; i < cmpNames.length; ++i) {
            cmpNames[i] = CutoffCmp.comparators[i].getLongName();
        }
        this.cutoffCmpGroup1Cb.setModel(new DefaultComboBoxModel<String>(cmpNames));
        this.cutoffCmpGroup1Cb.setSelectedItem(CutoffCmp.GE.getLongName());
        this.cutoffCmpGroup2Cb.setModel(new DefaultComboBoxModel<String>(cmpNames));
        this.cutoffCmpGroup2Cb.setSelectedItem(CutoffCmp.LT.getLongName());
        this.cutoffValueGroup1.getDocument().addDocumentListener(docCompleteListener);
        this.cutoffValueGroup1.setText("1.5");
        this.cutoffValueGroup2.getDocument().addDocumentListener(docCompleteListener);
        this.cutoffValueGroup2.setText("1.5");
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private void updateState(DocumentEvent e) {
        boolean complete = false;
        boolean bl = complete = this.isValidNumber(this.cutoffValueGroup1.getText()) && this.isValidNumber(this.cutoffValueGroup2.getText());
        if (complete) {
            this.setMessage(MessageStatus.INFO, "Define the two groups by cutoff-values");
        } else {
            this.setMessage(MessageStatus.WARN, "Put valid cutoff-values");
        }
        this.setComplete(complete);
    }

    public int getCutoffAttributeIndex() {
        int index = this.cutoffAttributeSelect.getSelectedIndex();
        return index;
    }

    public String getCutoffAttributeString() {
        return this.cutoffAttributeSelect.getSelectedItem().toString();
    }

    public JComponent createControls() {
        return this;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.cutoffCmpGroup1Cb = new JComboBox();
        this.cutoffValueGroup1 = new JTextField();
        this.attributeLabel3 = new JLabel();
        this.attributeLabel = new JLabel();
        this.cutoffAttributeSelect = new JComboBox();
        this.attributeLabel4 = new JLabel();
        this.cutoffCmpGroup2Cb = new JComboBox();
        this.cutoffValueGroup2 = new JTextField();
        this.attributeLabel1 = new JLabel();
        this.attributeLabel2 = new JLabel();
        this.cutoffValueGroup1.setColumns(6);
        this.attributeLabel3.setText("Group 1:");
        this.attributeLabel.setText("Take values to group from:");
        this.attributeLabel4.setText("Group 2:");
        this.cutoffValueGroup2.setColumns(6);
        this.attributeLabel1.setText("Values that are");
        this.attributeLabel2.setText("Values that are");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.attributeLabel).addGap(54, 54, 54).addComponent(this.cutoffAttributeSelect, 0, 424, Short.MAX_VALUE)).addComponent(this.attributeLabel3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.attributeLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 602, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributeLabel1).addComponent(this.attributeLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cutoffCmpGroup1Cb, -2, 390, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffValueGroup1, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cutoffCmpGroup2Cb, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffValueGroup2, -2, -1, -2)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeLabel).addComponent(this.cutoffAttributeSelect, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.attributeLabel3).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutoffCmpGroup1Cb, -2, -1, -2).addComponent(this.cutoffValueGroup1, -2, -1, -2).addComponent(this.attributeLabel2)).addGap(18, 18, 18).addComponent(this.attributeLabel4).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutoffCmpGroup2Cb, -2, -1, -2).addComponent(this.cutoffValueGroup2, -2, -1, -2).addComponent(this.attributeLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public CutoffCmp[] getGroupCutoffCmps() {
        return new CutoffCmp[]{CutoffCmp.getFromName((String)this.cutoffCmpGroup1Cb.getSelectedItem()), CutoffCmp.getFromName((String)this.cutoffCmpGroup2Cb.getSelectedItem())};
    }

    public double[] getGroupCutoffValues() {
        return new double[]{Double.parseDouble(this.cutoffValueGroup1.getText()), Double.parseDouble(this.cutoffValueGroup2.getText())};
    }

    public void setAttributes(List<IElementAttribute> attrs) {
        if (attrs != null) {
            AttrOption[] attrOptions = new AttrOption[attrs.size()];
            for (int i = 0; i < attrs.size(); ++i) {
                attrOptions[i] = new AttrOption(attrs.get(i));
            }
            this.cutoffAttributeSelect.setModel(new DefaultComboBoxModel<AttrOption>(attrOptions));
            this.cutoffAttributeSelect.setSelectedIndex(0);
            this.cutoffAttributeSelect.setEnabled(true);
            this.cutoffAttributeSelect.setVisible(true);
            this.attributeLabel.setVisible(true);
        } else {
            this.dissableAttrCb();
        }
    }

    private void dissableAttrCb() {
        this.cutoffAttributeSelect.setModel(new DefaultComboBoxModel());
        this.cutoffAttributeSelect.setEnabled(false);
        this.cutoffAttributeSelect.setVisible(false);
        this.attributeLabel.setVisible(false);
    }

    public class AttrOption {
        private String name;
        private IElementAttribute attr;

        public AttrOption(String name) {
            this.name = name;
        }

        public AttrOption(IElementAttribute attr) {
            this.attr = attr;
        }

        public IElementAttribute getAttr() {
            return this.attr;
        }

        public String toString() {
            return this.attr != null ? this.attr.getName() : this.name;
        }
    }
}

