/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.groupcomparison.wizard;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.ArrayUtils;
import org.gitools.heatmap.Heatmap;
import org.gitools.label.AnnotationsPatternProvider;
import org.gitools.label.LabelProvider;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.matrix.filter.MatrixViewLabelFilter;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.PageDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;
import org.gitools.ui.wizard.common.PatternSourcePage;

public class GroupComparisonGroupingByLabelPage
extends AbstractWizardPage {
    private Heatmap hm;
    private String colsPatt;
    private ButtonGroup applyGroup;
    private JButton colsPattBtn;
    private JTextField colsPattFld;
    private JRadioButton colsRb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton loadBtn1;
    private JButton loadBtn2;
    private JButton pasteSelected1;
    private JButton pasteSelected2;
    private JButton pasteUnselected1;
    private JButton pasteUnselected2;
    private JTextArea patterns1;
    private JTextArea patterns2;
    private JButton saveBtn1;
    private JButton saveBtn2;
    private JCheckBox useRegexCheck;

    public GroupComparisonGroupingByLabelPage(Heatmap hm) {
        this.hm = hm;
        this.initComponents();
        this.setComplete(false);
        this.colsPattBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupComparisonGroupingByLabelPage.this.selectColsPattern();
            }
        });
        this.patterns1.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                GroupComparisonGroupingByLabelPage.this.saveBtn1.setEnabled(GroupComparisonGroupingByLabelPage.this.patterns1.getDocument().getLength() > 0);
                GroupComparisonGroupingByLabelPage.this.setComplete(GroupComparisonGroupingByLabelPage.this.patterns1.getDocument().getLength() > 0 && GroupComparisonGroupingByLabelPage.this.patterns2.getDocument().getLength() > 0);
            }
        });
        this.patterns2.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                GroupComparisonGroupingByLabelPage.this.saveBtn2.setEnabled(GroupComparisonGroupingByLabelPage.this.patterns2.getDocument().getLength() > 0);
                GroupComparisonGroupingByLabelPage.this.setComplete(GroupComparisonGroupingByLabelPage.this.patterns1.getDocument().getLength() > 0 && GroupComparisonGroupingByLabelPage.this.patterns2.getDocument().getLength() > 0);
            }
        });
        this.colsPatt = "${id}";
        this.colsPattFld.setText("id");
        this.setTitle("Group Comparison Analysis");
        this.setMessage("Choose the two column groups to compare");
        this.setFilterDimension(MatrixViewLabelFilter.FilterDimension.COLUMNS);
    }

    protected String readNamesFromFile(File file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void selectColsPattern() {
        PatternSourcePage page = new PatternSourcePage(this.hm.getColumnDim().getAnnotations(), true);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.colsPatt = page.getPattern();
        this.colsPattFld.setText(page.getPatternTitle());
    }

    public MatrixViewLabelFilter.FilterDimension getFilterDimension() {
        return MatrixViewLabelFilter.FilterDimension.COLUMNS;
    }

    private void setFilterDimension(MatrixViewLabelFilter.FilterDimension fd) {
        this.colsRb.setSelected(true);
    }

    public String getPattern() {
        return this.colsPatt;
    }

    public int[] getGroup1() {
        return this.getGroupIndices(this.patterns1);
    }

    public int[] getGroup2() {
        return this.getGroupIndices(this.patterns2);
    }

    private int[] getGroupIndices(JTextArea patterns) {
        ArrayList<String> values = new ArrayList<String>();
        StringReader sr = new StringReader(patterns.getText());
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                values.add(line);
            }
        }
        catch (IOException ex) {
            ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            dlg.setVisible(true);
        }
        MatrixColumnsLabelProvider labelProvider = new MatrixColumnsLabelProvider((IMatrix)this.hm.getMatrixView());
        AnnotationMatrix am = this.hm.getColumnDim().getAnnotations();
        labelProvider = new AnnotationsPatternProvider((LabelProvider)labelProvider, am, this.getPattern());
        int[] visibleCols = this.hm.getMatrixView().getVisibleColumns();
        int[] groupCols = MatrixViewLabelFilter.filterLabels((LabelProvider)labelProvider, values, (boolean)this.isUseRegexChecked(), (int[])visibleCols);
        int[] groupColIndices = new int[groupCols.length];
        for (int i = 0; i < groupCols.length; ++i) {
            groupColIndices[i] = ArrayUtils.indexOf((int[])visibleCols, (int)groupCols[i]);
        }
        return groupColIndices;
    }

    private ArrayList<String> getSelectedColumns() {
        ArrayList<String> selected = new ArrayList<String>();
        MatrixColumnsLabelProvider labelProvider = new MatrixColumnsLabelProvider((IMatrix)this.hm.getMatrixView());
        if (!this.getPattern().equalsIgnoreCase("${id}")) {
            labelProvider = new AnnotationsPatternProvider((LabelProvider)labelProvider, this.hm.getColumnDim().getAnnotations(), this.getPattern());
        }
        int[] selectedIndices = this.hm.getMatrixView().getSelectedColumns();
        for (int i = 0; i < selectedIndices.length; ++i) {
            selected.add(labelProvider.getLabel(selectedIndices[i]));
        }
        return selected;
    }

    public void setValues(List<String> values, JTextArea patterns) {
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            patterns.append(it.next() + "\n");
        }
    }

    private ArrayList<String> getUnselectedColumns() {
        int i;
        ArrayList<String> unselected = new ArrayList<String>();
        MatrixColumnsLabelProvider labelProvider = new MatrixColumnsLabelProvider((IMatrix)this.hm.getMatrixView());
        if (!this.getPattern().equalsIgnoreCase("${id}")) {
            labelProvider = new AnnotationsPatternProvider((LabelProvider)labelProvider, this.hm.getColumnDim().getAnnotations(), this.getPattern());
        }
        int[] selectedIndices = this.hm.getMatrixView().getSelectedColumns();
        int visibleColumnsCount = this.hm.getMatrixView().getColumnCount();
        int[] unselectedIndices = new int[visibleColumnsCount - selectedIndices.length];
        int count = 0;
        for (i = 0; i < visibleColumnsCount; ++i) {
            if (ArrayUtils.contains((int[])selectedIndices, (int)i)) continue;
            unselectedIndices[count] = i;
            ++count;
        }
        for (i = 0; i < unselectedIndices.length; ++i) {
            unselected.add(labelProvider.getLabel(unselectedIndices[i]));
        }
        return unselected;
    }

    public boolean isUseRegexChecked() {
        return this.useRegexCheck.isSelected();
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.useRegexCheck = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.patterns1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.loadBtn1 = new JButton();
        this.saveBtn1 = new JButton();
        this.colsPattFld = new JTextField();
        this.colsPattBtn = new JButton();
        this.colsRb = new JRadioButton();
        this.pasteSelected1 = new JButton();
        this.pasteUnselected1 = new JButton();
        this.loadBtn2 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.patterns2 = new JTextArea();
        this.pasteUnselected2 = new JButton();
        this.jLabel2 = new JLabel();
        this.pasteSelected2 = new JButton();
        this.saveBtn2 = new JButton();
        this.jLabel1.setText("Column labels for group 1:");
        this.useRegexCheck.setText("Use regular expressions");
        this.patterns1.setColumns(20);
        this.patterns1.setRows(6);
        this.jScrollPane1.setViewportView(this.patterns1);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont((float)this.jLabel3.getFont().getSize() - 2.0f));
        this.jLabel3.setText("One label or regular expression per line");
        this.loadBtn1.setText("Load...");
        this.loadBtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.loadBtn1ActionPerformed(evt);
            }
        });
        this.saveBtn1.setText("Save...");
        this.saveBtn1.setEnabled(false);
        this.saveBtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.saveBtn1ActionPerformed(evt);
            }
        });
        this.colsPattFld.setEditable(false);
        this.colsPattBtn.setText("Change...");
        this.applyGroup.add(this.colsRb);
        this.colsRb.setText("Columns");
        this.pasteSelected1.setText("paste Selected");
        this.pasteSelected1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.pasteSelected1ActionPerformed(evt);
            }
        });
        this.pasteUnselected1.setText("paste Unselected");
        this.pasteUnselected1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.pasteUnselected1ActionPerformed(evt);
            }
        });
        this.loadBtn2.setText("Load...");
        this.loadBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.loadBtn2ActionPerformed(evt);
            }
        });
        this.patterns2.setColumns(20);
        this.patterns2.setRows(6);
        this.jScrollPane2.setViewportView(this.patterns2);
        this.pasteUnselected2.setText("paste Unselected");
        this.pasteUnselected2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.pasteUnselected2ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Column labels for group 2:");
        this.pasteSelected2.setText("paste Selected");
        this.pasteSelected2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.pasteSelected2ActionPerformed(evt);
            }
        });
        this.saveBtn2.setText("Save...");
        this.saveBtn2.setEnabled(false);
        this.saveBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroupComparisonGroupingByLabelPage.this.saveBtn2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.colsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsPattFld, -1, 343, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsPattBtn)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pasteUnselected1, -1, -1, Short.MAX_VALUE).addComponent(this.saveBtn1, GroupLayout.Alignment.TRAILING, -1, 134, Short.MAX_VALUE).addComponent(this.loadBtn1, -1, 134, Short.MAX_VALUE).addComponent(this.pasteSelected1, -1, 134, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane2, -1, 378, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pasteUnselected2, -1, -1, Short.MAX_VALUE).addComponent(this.saveBtn2, GroupLayout.Alignment.TRAILING, -1, 134, Short.MAX_VALUE).addComponent(this.loadBtn2, -1, 134, Short.MAX_VALUE).addComponent(this.pasteSelected2, -1, 134, Short.MAX_VALUE))).addComponent(this.jLabel3).addComponent(this.useRegexCheck)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colsPattBtn).addComponent(this.colsRb).addComponent(this.colsPattFld, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loadBtn1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteSelected1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteUnselected1)).addComponent(this.jScrollPane1, -2, 134, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loadBtn2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteSelected2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteUnselected2)).addComponent(this.jScrollPane2, -2, 134, -2)).addGap(18, 18, 18).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.useRegexCheck).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadBtn1ActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooserUtils.selectFile("Select the file containing values", Settings.getDefault().getLastFilterPath(), 2);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastFilterPath(file.getParent());
            this.patterns1.setText(this.readNamesFromFile(file));
        }
        catch (IOException ex) {
            ExceptionDialog edlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }

    private void saveBtn1ActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooserUtils.selectFile("Select file name ...", Settings.getDefault().getLastFilterPath(), 1);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastFilterPath(file.getParent());
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.append(this.patterns1.getText()).append('\n');
            bw.close();
        }
        catch (Exception ex) {
            ExceptionDialog edlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }

    private void pasteSelected1ActionPerformed(ActionEvent evt) {
        ArrayList<String> selectedColsLabels = this.getSelectedColumns();
        this.setValues(selectedColsLabels, this.patterns1);
    }

    private void pasteUnselected1ActionPerformed(ActionEvent evt) {
        ArrayList<String> unselectedColsLabels = this.getUnselectedColumns();
        this.setValues(unselectedColsLabels, this.patterns1);
    }

    private void loadBtn2ActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooserUtils.selectFile("Select the file containing values", Settings.getDefault().getLastFilterPath(), 2);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastFilterPath(file.getParent());
            this.patterns2.setText(this.readNamesFromFile(file));
        }
        catch (IOException ex) {
            ExceptionDialog edlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }

    private void pasteUnselected2ActionPerformed(ActionEvent evt) {
        ArrayList<String> unselectedColsLabels = this.getUnselectedColumns();
        this.setValues(unselectedColsLabels, this.patterns2);
    }

    private void pasteSelected2ActionPerformed(ActionEvent evt) {
        ArrayList<String> selectedColsLabels = this.getSelectedColumns();
        this.setValues(selectedColsLabels, this.patterns2);
    }

    private void saveBtn2ActionPerformed(ActionEvent evt) {
    }
}

