/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.groupcomparison.wizard;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.util.ArrayList;
import org.gitools.analysis.groupcomparison.GroupComparisonAnalysis;
import org.gitools.datafilters.BinaryCutoff;
import org.gitools.heatmap.Heatmap;
import org.gitools.model.Attribute;
import org.gitools.ui.analysis.groupcomparison.wizard.GroupComparisonGroupingByLabelPage;
import org.gitools.ui.analysis.groupcomparison.wizard.GroupComparisonGroupingByValuePage;
import org.gitools.ui.analysis.groupcomparison.wizard.GroupComparisonSelectAttributePage;
import org.gitools.ui.analysis.wizard.AnalysisDetailsPage;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;

public class GroupComparisonAnalysisFromEditorWizard
extends AbstractWizard {
    protected Heatmap heatmap;
    protected GroupComparisonGroupingByValuePage groupByValuePage;
    protected GroupComparisonGroupingByLabelPage groupByLabelPage;
    protected GroupComparisonSelectAttributePage attrSelectPage;
    protected AnalysisDetailsPage analysisDetailsPage;

    public GroupComparisonAnalysisFromEditorWizard(Heatmap heatmap) {
        this.setTitle("Correlation analysis");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Comparison.png", (int)96));
        this.heatmap = heatmap;
    }

    public void addPages() {
        this.attrSelectPage = new GroupComparisonSelectAttributePage();
        this.attrSelectPage.setAttributes(this.heatmap.getMatrixView().getCellAttributes());
        this.addPage((IWizardPage)this.attrSelectPage);
        this.groupByLabelPage = new GroupComparisonGroupingByLabelPage(this.heatmap);
        this.addPage((IWizardPage)this.groupByLabelPage);
        this.groupByValuePage = new GroupComparisonGroupingByValuePage();
        this.groupByValuePage.setAttributes(this.heatmap.getMatrixView().getCellAttributes());
        this.addPage((IWizardPage)this.groupByValuePage);
        this.analysisDetailsPage = new AnalysisDetailsPage();
        this.addPage((IWizardPage)this.analysisDetailsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        page = this.getCurrentPage();
        if (page == this.attrSelectPage) {
            if (this.attrSelectPage.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_LABEL)) {
                return super.getPage(this.groupByLabelPage.getId());
            }
            if (this.attrSelectPage.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_VALUE)) {
                return super.getPage(this.groupByValuePage.getId());
            }
        } else {
            if (page == this.groupByLabelPage) {
                if (this.groupByLabelPage.getGroup1().length == 0) {
                    this.groupByLabelPage.setMessage(MessageStatus.ERROR, "No columns match values in Group 1");
                    return page;
                }
                if (this.groupByLabelPage.getGroup2().length == 0) {
                    this.groupByLabelPage.setMessage(MessageStatus.ERROR, "No columns match values in Group 2");
                    return page;
                }
                this.updateAnalysisDetails();
                return super.getPage(this.analysisDetailsPage.getId());
            }
            if (page == this.groupByValuePage) {
                this.updateAnalysisDetails();
                return super.getPage(this.analysisDetailsPage.getId());
            }
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        page = this.getCurrentPage();
        if (page == this.groupByLabelPage || page == this.groupByValuePage) {
            return super.getPage(this.attrSelectPage.getId());
        }
        if (page == this.analysisDetailsPage) {
            if (this.attrSelectPage.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_LABEL)) {
                return super.getPage(this.groupByLabelPage.getId());
            }
            if (this.attrSelectPage.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_VALUE)) {
                return super.getPage(this.groupByValuePage.getId());
            }
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        IWizardPage page = this.getCurrentPage();
        return canFinish |= page.isComplete() && (page == this.groupByLabelPage || page == this.groupByValuePage);
    }

    public GroupComparisonAnalysis getAnalysis() {
        GroupComparisonAnalysis a = new GroupComparisonAnalysis();
        a.setTitle(this.analysisDetailsPage.getAnalysisTitle());
        a.setDescription(this.analysisDetailsPage.getAnalysisNotes());
        a.setAttributes(this.analysisDetailsPage.getAnalysisAttributes());
        a.setTransposeData(false);
        a.setAttributeIndex(this.attrSelectPage.getAttributeIndex());
        a.setColumnGrouping(this.attrSelectPage.getColumnGrouping());
        a.setTest(this.attrSelectPage.getTest());
        a.setMtc(this.attrSelectPage.getMtc());
        a.setRowAnnotations(this.heatmap.getRowDim().getAnnotations());
        a.setRowHeaders(this.heatmap.getRowDim().getHeaders());
        a.setColumnAnnotations(this.heatmap.getColumnDim().getAnnotations());
        a.setColumnHeaders(this.heatmap.getColumnDim().getHeaders());
        if (a.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_LABEL)) {
            a.setGroup1(this.groupByLabelPage.getGroup1());
            a.setGroup2(this.groupByLabelPage.getGroup2());
        } else if (a.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_VALUE)) {
            a.setGroup1(new BinaryCutoff(this.groupByValuePage.getGroupCutoffCmps()[0], this.groupByValuePage.getGroupCutoffValues()[0]), this.groupByValuePage.getCutoffAttributeIndex());
            a.setGroup2(new BinaryCutoff(this.groupByValuePage.getGroupCutoffCmps()[1], this.groupByValuePage.getGroupCutoffValues()[1]), this.groupByValuePage.getCutoffAttributeIndex());
        }
        return a;
    }

    private void updateAnalysisDetails() {
        ArrayList<Attribute> analysisAttributes = new ArrayList<Attribute>();
        if (this.attrSelectPage.getColumnGrouping().equals(GroupComparisonAnalysis.COLUMN_GROUPING_BY_LABEL)) {
            analysisAttributes.add(new Attribute("Group 1", "user defined group"));
            analysisAttributes.add(new Attribute("Group 2", "user defined group"));
        } else {
            CutoffCmp[] groupCutoffCmps = this.groupByValuePage.getGroupCutoffCmps();
            double[] groupCutoffValues = this.groupByValuePage.getGroupCutoffValues();
            String cutoffAttributeString = this.groupByValuePage.getCutoffAttributeString();
            for (int i = 0; i < groupCutoffCmps.length; ++i) {
                String group = "Group " + (i + 1);
                String name = cutoffAttributeString + " " + groupCutoffCmps[i].getLongName() + " " + String.valueOf(groupCutoffValues[i]);
                analysisAttributes.add(new Attribute(group, name));
            }
        }
        this.analysisDetailsPage.setAnalysisAttributes(analysisAttributes);
    }
}

