/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.groupcomparison.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.groupcomparison.GroupComparisonAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class GroupComparisonAnalysisEditor
extends AnalysisDetailsEditor<GroupComparisonAnalysis> {
    public GroupComparisonAnalysisEditor(GroupComparisonAnalysis analysis) {
        super(analysis, "/vm/analysis/groupcomparison/analysis_details.vm", null);
    }

    @Override
    protected void prepareContext(VelocityContext context) {
        PersistenceManager.FileRef fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((GroupComparisonAnalysis)this.analysis).getData());
        context.put("dataFile", (Object)(fileRef != null ? fileRef.getFile().getName() : "Not defined"));
        context.put("mtc", (Object)((GroupComparisonAnalysis)this.analysis).getMtc().getName());
    }

    @Override
    protected void performUrlAction(String name, Map<String, String> params) {
        if ("NewDataHeatmap".equals(name)) {
            this.newDataHeatmap();
        } else if ("NewResultsHeatmap".equals(name)) {
            this.newResultsHeatmap();
        }
    }

    private void newDataHeatmap() {
        if (((GroupComparisonAnalysis)this.analysis).getData() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain data.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from data ...", 1);
                MatrixView dataTable = new MatrixView(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getData());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getTitle() + " (data)");
                heatmap.getRowDim().setAnnotations(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getRowAnnotations());
                GroupComparisonAnalysisEditor.this.copyHeaders(heatmap.getRowDim(), ((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getRowHeaders());
                heatmap.getColumnDim().setAnnotations(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getColumnAnnotations());
                GroupComparisonAnalysisEditor.this.copyHeaders(heatmap.getColumnDim(), ((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getColumnHeaders());
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(GroupComparisonAnalysisEditor.this.getName(), "comparison", "-data", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("New heatmap created.");
                    }
                });
            }
        });
    }

    private void copyHeaders(HeatmapDim dim, List<HeatmapHeader> headers) {
        dim.removeHeader(0);
        for (HeatmapHeader hh : headers) {
            HeatmapTextLabelsHeader oldHeader;
            HeatmapTextLabelsHeader headerCopy = null;
            if (hh instanceof HeatmapTextLabelsHeader) {
                oldHeader = (HeatmapTextLabelsHeader)hh;
                HeatmapTextLabelsHeader textHeaderCopy = new HeatmapTextLabelsHeader(dim);
                textHeaderCopy.setFont(oldHeader.getFont());
                textHeaderCopy.setForegroundColor(oldHeader.getForegroundColor());
                textHeaderCopy.setLabelAnnotation(oldHeader.getLabelAnnotation());
                textHeaderCopy.setLabelPattern(oldHeader.getLabelPattern());
                textHeaderCopy.setLabelSource(oldHeader.getLabelSource());
                headerCopy = textHeaderCopy;
            } else if (hh instanceof HeatmapColoredLabelsHeader) {
                oldHeader = (HeatmapColoredLabelsHeader)hh;
                HeatmapColoredLabelsHeader colorHeaderCopy = new HeatmapColoredLabelsHeader(dim);
                colorHeaderCopy.setLabelColor(oldHeader.getLabelColor());
                colorHeaderCopy.setLabelColorDefined(oldHeader.isLabelColorDefined());
                colorHeaderCopy.setLabelFont(oldHeader.getLabelFont());
                colorHeaderCopy.setLabelRotated(oldHeader.isLabelRotated());
                colorHeaderCopy.setLabelVisible(oldHeader.isLabelVisible());
                colorHeaderCopy.setMargin(oldHeader.getMargin());
                colorHeaderCopy.setSeparationGrid(oldHeader.isSeparationGrid());
                colorHeaderCopy.setThickness(oldHeader.getThickness());
                HeatmapColoredLabelsHeader.ColoredLabel[] clusters = oldHeader.getClusters();
                HeatmapColoredLabelsHeader.ColoredLabel[] newClusters = new HeatmapColoredLabelsHeader.ColoredLabel[clusters.length];
                int index = 0;
                for (HeatmapColoredLabelsHeader.ColoredLabel cl : clusters) {
                    HeatmapColoredLabelsHeader.ColoredLabel newcl;
                    HeatmapColoredLabelsHeader heatmapColoredLabelsHeader = colorHeaderCopy;
                    heatmapColoredLabelsHeader.getClass();
                    newClusters[index] = newcl = new HeatmapColoredLabelsHeader.ColoredLabel(heatmapColoredLabelsHeader, cl.getName(), cl.getColor());
                    ++index;
                }
                colorHeaderCopy.setClusters(newClusters);
                colorHeaderCopy.setAssignedColoredLabels(oldHeader.getAssignedColoredLabels());
                dim.getAnnotations().getRows();
                headerCopy = colorHeaderCopy;
            }
            headerCopy.setBackgroundColor(hh.getBackgroundColor());
            headerCopy.setSize(hh.getSize());
            headerCopy.setTitle(hh.getTitle());
            headerCopy.setVisible(hh.isVisible());
            dim.addHeader(headerCopy);
        }
    }

    private void newResultsHeatmap() {
        if (((GroupComparisonAnalysis)this.analysis).getResults() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain results.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from results ...", 1);
                MatrixView dataTable = new MatrixView(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getResults());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getTitle() + " (results)");
                heatmap.getRowDim().setAnnotations(((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getRowAnnotations());
                GroupComparisonAnalysisEditor.this.copyHeaders(heatmap.getRowDim(), ((GroupComparisonAnalysis)GroupComparisonAnalysisEditor.this.analysis).getRowHeaders());
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(GroupComparisonAnalysisEditor.this.getName(), "comparison", "-results", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("Heatmap for group comparison results created.");
                    }
                });
            }
        });
    }
}

