/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.editor;

import edu.upf.bg.formatter.GenericFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.ActionSet;
import org.gitools.ui.platform.actions.ActionSetUtils;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.panel.Html4Panel;
import org.gitools.ui.platform.panel.TemplatePanel;
import org.gitools.ui.utils.LogUtils;
import org.lobobrowser.html.FormInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisDetailsEditor<A>
extends AbstractEditor {
    private static final Logger log = LoggerFactory.getLogger(AnalysisDetailsEditor.class);
    protected A analysis;
    protected String template;
    protected ActionSet toolBar = null;
    protected TemplatePanel templatePanel;

    public AnalysisDetailsEditor(A analysis, String template, ActionSet toolBar) {
        this.analysis = analysis;
        this.template = template;
        this.toolBar = toolBar;
        this.createComponents();
    }

    private void createComponents() {
        this.templatePanel = new TemplatePanel(){

            protected void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) throws Html4Panel.LinkVetoException {
                AnalysisDetailsEditor.this.submitForm(method, action, target, enctype, formInputs);
            }

            protected void performUrlAction(String name, Map<String, String> params) {
                AnalysisDetailsEditor.this.performUrlAction(name, params);
            }
        };
        try {
            URL url = ((Object)((Object)this)).getClass().getResource(this.template);
            this.templatePanel.setTemplateFromResource(this.template, url);
            VelocityContext context = new VelocityContext();
            context.put("fmt", (Object)new GenericFormatter());
            context.put("analysis", this.analysis);
            this.prepareContext(context);
            this.templatePanel.render(context);
        }
        catch (Exception e) {
            LogUtils.logException(e, log);
        }
        this.setLayout(new BorderLayout());
        if (this.toolBar != null) {
            this.add(ActionSetUtils.createToolBar((ActionSet)this.toolBar), "North");
        }
        this.add((Component)this.templatePanel, "Center");
    }

    protected void prepareContext(VelocityContext context) {
    }

    public Object getModel() {
        return this.analysis;
    }

    public void doVisible() {
        AppFrame.instance().setLeftPanelVisible(true);
        AppFrame.instance().getPropertiesView().updateContext(null);
        AppFrame.instance().getDetailsView().updateContext(null);
        this.templatePanel.requestFocusInWindow();
    }

    protected void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) {
    }

    protected void performUrlAction(String name, Map<String, String> params) {
    }
}

